/*
 * Decompiled with CFR 0.152.
 */
package co.uk.automationconsultants.compliance.rest;

import co.uk.automationconsultants.compliance.json.settings.LicenseJson;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Scanned
@Path(value="/license")
public class LicenseRest {
    private static final int NO_LICENSE = 0;
    private static final int FULL_LICENSE = 1;
    private static final int EVAL_LICENSE = 2;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public LicenseRest(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getLicense(@Context HttpServletRequest request) {
        if (this.getLicenseType() == 0) {
            return Response.ok((Object)new LicenseJson("none")).build();
        }
        if (this.getLicenseType() == 2) {
            return Response.ok((Object)new LicenseJson("true")).build();
        }
        if (this.getLicenseType() == 1) {
            return Response.ok((Object)new LicenseJson("true")).build();
        }
        return Response.ok((Object)new LicenseJson("none")).build();
    }

    private int getLicenseType() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isActive() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isMaintenanceExpired() || !((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) {
                return 0;
            }
            if (((PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation()) {
                return 1;
            }
            return 1;
        }
        return 0;
    }
}

