/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.azure.ao.AzureRepository;
import com.moveworkforward.confluence.azure.model.AzureGlobalSettings;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class AzureGlobalSettingsService {
    private final AzureRepository repository;
    protected final PermissionManager permissionManager;

    @Inject
    public AzureGlobalSettingsService(AzureRepository repository, @ComponentImport PermissionManager permissionManager) {
        this.repository = repository;
        this.permissionManager = permissionManager;
    }

    public AzureGlobalSettings get() {
        this.checkAdminPermissions();
        return this.doGet();
    }

    public AzureGlobalSettings save(AzureGlobalSettings globalSettings) {
        this.checkAdminPermissions();
        AzureGlobalSettings saved = this.doGet();
        if (saved.getId() != null) {
            globalSettings.setId(saved.getId());
        }
        return (AzureGlobalSettings)((Object)this.repository.save((Object)globalSettings));
    }

    protected void checkAdminPermissions() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator(confluenceUser)) {
            throw new RuntimeException("User doesn't have permissions");
        }
    }

    private AzureGlobalSettings doGet() {
        return this.repository.getAll(AzureGlobalSettings.class).stream().findFirst().orElse(new AzureGlobalSettings());
    }
}

