/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.service;

import com.moveworkforward.ao.entity.PluginSettingEntity;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureGlobalSettings;
import com.moveworkforward.confluence.azure.model.SearchConfigurationParameters;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import com.moveworkforward.confluence.common.validation.GeneralRecordValidator;
import com.moveworkforward.v2.ao.impl.AbstractPluginRepository;
import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AzureDevOpsSettingManager
implements MacroConfigurationService<AzureConfigurationsHolder, SearchConfigurationParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureDevOpsSettingManager.class);
    private final AbstractPluginRepository<PluginSettingEntity> repository;
    private final GeneralRecordValidator validationHelper;
    private final CacheableAzureRestClient azureRestClient;

    @Inject
    public AzureDevOpsSettingManager(AbstractPluginRepository<PluginSettingEntity> repository, GeneralRecordValidator validationHelper, CacheableAzureRestClient azureRestClient) {
        this.repository = repository;
        this.validationHelper = validationHelper;
        this.azureRestClient = azureRestClient;
    }

    public AzureGlobalSettings getGlobalSettings() {
        return this.repository.getAll(AzureGlobalSettings.class).stream().findFirst().orElse(new AzureGlobalSettings());
    }

    public AzureConfigurationsHolder get(SearchConfigurationParameters searchConfigurationParameters) {
        AzureGlobalSettings globalSettings = this.getGlobalSettings();
        AzureConfigurationsHolder configurationsHolder = new AzureConfigurationsHolder();
        this.azureRestClient.updateCacheConfiguration(globalSettings.getCacheMaxEntries(), globalSettings.getCacheExpirationInSeconds());
        log.debug("Personal tokens allowed: '{}', fallback: '{}'", (Object)globalSettings.isAllowPersonal(), (Object)globalSettings.isFallback());
        if (globalSettings.isAllowPersonal()) {
            String userKey = this.validationHelper.getCurrentUser().getUserKey();
            List<AzureConfiguration> personalConfigurations = this.repository.getByTag(userKey, AzureConfiguration.class);
            personalConfigurations = this.filterConfigurations(personalConfigurations, searchConfigurationParameters);
            this.addConfigurations(configurationsHolder.getConfigurations(), personalConfigurations, globalSettings.isFallback());
            log.debug("Personal configurations are defined {}", (Object)(!personalConfigurations.isEmpty() ? 1 : 0));
        }
        if (configurationsHolder.getConfigurations().isEmpty() || globalSettings.isFallback()) {
            log.debug("Personal configurations are not found or fallback is allowed. Adding space level configurations");
            List<AzureConfiguration> spaceConfigurations = this.repository.getByTag(searchConfigurationParameters.getSpaceKey(), AzureConfiguration.class);
            spaceConfigurations = this.filterConfigurations(spaceConfigurations, searchConfigurationParameters);
            this.addConfigurations(configurationsHolder.getConfigurations(), spaceConfigurations, globalSettings.isFallback());
            log.debug("Space configurations are defined {}", (Object)spaceConfigurations.isEmpty());
        } else {
            log.debug("Space configurations have not been added");
        }
        if (configurationsHolder.getConfigurations().isEmpty() || globalSettings.isFallback()) {
            log.debug("Global configurations are being added");
            List<AzureConfiguration> globalConfigurations = this.repository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", AzureConfiguration.class);
            globalConfigurations = this.filterConfigurations(globalConfigurations, searchConfigurationParameters);
            this.addConfigurations(configurationsHolder.getConfigurations(), globalConfigurations, globalSettings.isFallback());
        } else {
            log.debug("Global configurations have not been added");
        }
        return configurationsHolder;
    }

    private void addConfigurations(List<AzureConfiguration> allConfigurations, List<AzureConfiguration> configurationsToAdd, boolean fallback) {
        if (fallback) {
            allConfigurations.addAll(configurationsToAdd);
        } else if (!configurationsToAdd.isEmpty()) {
            allConfigurations.add(configurationsToAdd.get(0));
        }
    }

    private List<AzureConfiguration> filterConfigurations(List<AzureConfiguration> configurations, SearchConfigurationParameters parameters) {
        return configurations.stream().filter(this::filterByEnabled).filter(this::filterByAuthorization).filter(configuration -> this.filterByBaseUrl((AzureConfiguration)configuration, parameters.getBaseUrl())).filter(configuration -> this.filterByOrganization((AzureConfiguration)configuration, parameters.getOrganization())).filter(configuration -> this.filterBySpace((AzureConfiguration)configuration, parameters.getSpaceKey())).sorted(Comparator.comparing(AzureConfiguration::getBaseUrl, Comparator.nullsLast(Comparator.comparing(s -> s))).thenComparing(AzureConfiguration::getOrganization, Comparator.nullsLast(Comparator.comparing(s -> s)))).collect(Collectors.toList());
    }

    private boolean filterBySpace(AzureConfiguration configuration, String targetSpaceKey) {
        boolean result = configuration.isSpaceAllowed(targetSpaceKey);
        log.debug("Configuration '{}' can process space key({}): {}", new Object[]{configuration.getName(), targetSpaceKey, result});
        if (!result) {
            log.debug("Configuration for space '{}' is skipped due to -  level: {}, spaceKey: {}, includedSpaceKeys: {}, excludedSpaceKeys: {}", new Object[]{targetSpaceKey, configuration.getLevel(), configuration.getSpaceKey(), configuration.getIncludedSpaceKeys(), configuration.getExcludedSpaceKeys()});
        }
        return result;
    }

    private boolean filterByEnabled(AzureConfiguration configuration) {
        boolean result = configuration.isEnabled();
        log.debug("Configuration '{}' is enabled: {}", (Object)configuration.getName(), (Object)result);
        return result;
    }

    private boolean filterByOrganization(AzureConfiguration configuration, String targetOrganization) {
        boolean result = StringUtils.isBlank((CharSequence)configuration.getOrganization()) || configuration.getOrganization().equalsIgnoreCase(targetOrganization);
        log.debug("Configuration '{}' has matched organization({}): {}", new Object[]{configuration.getName(), targetOrganization, result});
        if (!result) {
            log.debug("Configuration for organization '{}' is skipped due to - organization: {}", (Object)targetOrganization, (Object)configuration.getOrganization());
        }
        return result;
    }

    private boolean filterByBaseUrl(AzureConfiguration configuration, String targetBaseUrl) {
        boolean result = StringUtils.isBlank((CharSequence)configuration.getBaseUrl());
        if (!result) {
            String configurationBaseUrl = AbstractLinkHelper.withoutTrailingSlash(configuration.getBaseUrl());
            String macrosBaseUrl = AbstractLinkHelper.withoutTrailingSlash(targetBaseUrl);
            configurationBaseUrl = AbstractLinkHelper.isOldApi(configurationBaseUrl) ? "https://dev.azure.com" : configurationBaseUrl;
            macrosBaseUrl = AbstractLinkHelper.isOldApi(macrosBaseUrl) ? "https://dev.azure.com" : macrosBaseUrl;
            result = configurationBaseUrl.equalsIgnoreCase(macrosBaseUrl);
        }
        log.debug("Configuration '{}' has matched base url({}): {}", new Object[]{configuration.getName(), targetBaseUrl, result});
        if (!result) {
            log.debug("Configuration for url '{}' is skipped due to - baseUrl: {}", (Object)targetBaseUrl, (Object)configuration.getBaseUrl());
        }
        return result;
    }

    private boolean filterByAuthorization(AzureConfiguration configuration) {
        boolean result = configuration.getAuthorization() != null && configuration.getAuthorization().isConfigured();
        log.debug("Configuration '{}' has configured authorization: {}", (Object)configuration.getName(), (Object)result);
        return result;
    }
}

