/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.rest;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.QueryLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureDateTimeFormat;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.PaginationMacroResponse;
import com.moveworkforward.confluence.azure.model.QueryMacroRequest;
import com.moveworkforward.confluence.azure.model.QueryRequest;
import com.moveworkforward.confluence.azure.model.QueryResponse;
import com.moveworkforward.confluence.azure.model.SearchConfigurationParameters;
import com.moveworkforward.confluence.azure.model.SearchMacroRequest;
import com.moveworkforward.confluence.azure.model.SearchRequest;
import com.moveworkforward.confluence.azure.model.SearchResponse;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.rest.WorkItemFieldsController;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/macro")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class AsyncMacroController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncMacroController.class);
    public final AzureRestClient azureRestClient;
    protected final TemplateRenderer renderer;
    private final AzureDevOpsSettingManager settingManager;

    @Inject
    public AsyncMacroController(AzureDevOpsSettingManager settingManager, CacheableAzureRestClient azureRestClient, @ComponentImport TemplateRenderer renderer) {
        this.settingManager = settingManager;
        this.azureRestClient = azureRestClient;
        this.renderer = renderer;
    }

    @POST
    @Path(value="/query")
    public PaginationMacroResponse query(QueryMacroRequest queryMacroRequest) {
        String url = queryMacroRequest.getUrl();
        QueryLinkHelper linkHelper = new QueryLinkHelper();
        String azureBaseUrl = linkHelper.getBaseUrl(url);
        List<String> fieldsToDisplay = queryMacroRequest.getFieldsToDisplay();
        fieldsToDisplay.removeIf(StringUtils::isBlank);
        String organizationID = linkHelper.getOrganizationID(url);
        String projectName = linkHelper.getProjectName(url);
        String queryId = linkHelper.getId(url);
        QueryRequest request = new QueryRequest(organizationID, projectName, queryId, queryMacroRequest.getLimit(), queryMacroRequest.getPage(), queryMacroRequest.getRecordsPerPage());
        SearchConfigurationParameters searchConfigurationParameters = new SearchConfigurationParameters(linkHelper.getOriginalBaseUrl(url), organizationID, queryMacroRequest.getSpaceKey());
        QueryResponse response = null;
        AzureConfiguration configuration = null;
        for (AzureConfiguration currentConfiguration : this.settingManager.get(searchConfigurationParameters).getConfigurations()) {
            log.debug("Get query items using: {}", (Object)currentConfiguration);
            try {
                response = this.azureRestClient.getQuery(azureBaseUrl, currentConfiguration.getAuthorization().getPersonalAccessToken(), request);
                if (response == null) continue;
                configuration = currentConfiguration;
                break;
            }
            catch (Exception e) {
                log.error("Can not get query using configuration: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, response);
        if (response == null || configuration == null) {
            log.debug("if we don't get a response it means request was failed but PAT is set");
            throw new RuntimeException("Invalid token: " + url);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", response.getName());
        model.put("url", url);
        List<WorkItemResponse> workItemResponses = response.getWorkItems();
        String token = configuration.getAuthorization().getPersonalAccessToken();
        Map<String, FieldsResponse.Field> allFields = AzureMacroUtils.getAllFields(this.azureRestClient, azureBaseUrl, token, organizationID, projectName, WorkItemFieldsController.DEFAULT_PARAMETERS);
        List workItems = workItemResponses.stream().map(AzureMacroUtils::workItemToModel).collect(Collectors.toList());
        AzureDateTimeFormat dateTimeFormat = Optional.ofNullable(this.settingManager.getGlobalSettings().getDateTimeFormat()).orElse(AzureDateTimeFormat.NONE);
        model.put("workItems", workItems);
        model.put("fieldsToDisplay", fieldsToDisplay);
        model.put("allFields", allFields);
        model.put("dateTimeFormat", (Object)dateTimeFormat);
        return new PaginationMacroResponse(queryMacroRequest.getPage(), response.getTotal(), AzureMacroUtils.render(this.renderer, model, "templates/mwf-ado-work-items-content.vm"));
    }

    @POST
    @Path(value="/search")
    public PaginationMacroResponse search(SearchMacroRequest searchMacroRequest) {
        String azureBaseurl = searchMacroRequest.getUrl();
        String organization = searchMacroRequest.getOrganization();
        String project = searchMacroRequest.getProject();
        String searchText = searchMacroRequest.getSearchText();
        Integer limit = searchMacroRequest.getLimit();
        SearchConfigurationParameters configurationParameters = new SearchConfigurationParameters(azureBaseurl, organization, searchMacroRequest.getSpaceKey());
        for (AzureConfiguration configuration : this.settingManager.get(configurationParameters).getConfigurations()) {
            log.debug("Search work items using: {}", (Object)configuration);
            List<String> fieldsToDisplay = searchMacroRequest.getFieldsToDisplay();
            fieldsToDisplay.removeIf(StringUtils::isBlank);
            String projectCondition = StringUtils.isBlank((CharSequence)project) ? "" : String.format("and [System.TeamProject] = '%1$s'", project);
            String query = String.format("select [System.Id] from WorkItems where ([System.Title] contains words '%1$s' or [System.Description] contains words '%1$s') %2$s order by [System.ChangedDate] desc", searchText, projectCondition);
            SearchRequest request = new SearchRequest(organization, project, query, limit, searchMacroRequest.getPage(), searchMacroRequest.getRecordsPerPage());
            try {
                SearchResponse response = this.azureRestClient.searchItems(azureBaseurl, configuration.getAuthorization().getPersonalAccessToken(), request);
                log.debug("URL: {}, response: {}", (Object)azureBaseurl, (Object)response);
                if (response == null) continue;
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("url", azureBaseurl);
                List<WorkItemResponse> workItemResponses = response.getWorkItems();
                String token = configuration.getAuthorization().getPersonalAccessToken();
                Map<String, FieldsResponse.Field> allFields = AzureMacroUtils.getAllFields(this.azureRestClient, azureBaseurl, token, organization, project, WorkItemFieldsController.DEFAULT_PARAMETERS);
                List workItems = workItemResponses.stream().map(AzureMacroUtils::workItemToModel).collect(Collectors.toList());
                AzureDateTimeFormat dateTimeFormat = Optional.ofNullable(this.settingManager.getGlobalSettings().getDateTimeFormat()).orElse(AzureDateTimeFormat.NONE);
                model.put("workItems", workItems);
                model.put("fieldsToDisplay", fieldsToDisplay);
                model.put("allFields", allFields);
                model.put("organization", organization);
                model.put("project", project);
                model.put("searchText", searchText);
                model.put("dateTimeFormat", (Object)dateTimeFormat);
                String html = null;
                html = response.getTotal() > 0 ? AzureMacroUtils.render(this.renderer, model, "templates/mwf-ado-work-items-content.vm") : AzureMacroUtils.render(this.renderer, model, "templates/mwf-ado-empty-search.vm");
                return new PaginationMacroResponse(searchMacroRequest.getPage(), response.getTotal(), html);
            }
            catch (Exception e) {
                log.warn("Can not search work items using configuration: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
            }
        }
        log.debug("if we don't get a response it means request was failed but PAT is set");
        throw new RuntimeException("Invalid token: " + searchMacroRequest.getUrl());
    }
}

