/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.WikiLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.WikiInfoResponse;
import com.moveworkforward.confluence.azure.model.WikiPageResponse;
import com.moveworkforward.confluence.azure.model.WikiRequest;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import jakarta.inject.Inject;
import java.io.File;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WikiMacroProcessor
extends AbstractAzureLinkProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WikiMacroProcessor.class);

    @Inject
    public WikiMacroProcessor(CacheableAzureRestClient azureRestClient, AzureDevOpsSettingManager configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new WikiLinkHelper());
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        String azureBaseUrl = this.getAzureHostUrl(parameters);
        String organizationID = this.getOrganization(parameters);
        String projectName = this.getProject(parameters);
        String wikiIdentifier = ((WikiLinkHelper)this.linkHelper).getWikiIdentifier(url);
        String id = ((AzureLinkHelper)this.linkHelper).getId(url);
        WikiRequest request = new WikiRequest(organizationID, projectName, wikiIdentifier, id);
        WikiPageResponse wikiPageResponse = null;
        AzureConfiguration acceptedConfiguration = null;
        for (AzureConfiguration configuration : configurationsHolder.getConfigurations()) {
            log.debug("Get wiki using: {}", (Object)configuration);
            try {
                wikiPageResponse = this.azureRestClient.getWikiPage(azureBaseUrl, configuration.getAuthorization().getPersonalAccessToken(), request);
                if (wikiPageResponse == null) break;
                acceptedConfiguration = configuration;
            }
            catch (Exception e) {
                log.warn("Can not get build status using configurations: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, wikiPageResponse);
        if (wikiPageResponse == null || StringUtils.isBlank((CharSequence)wikiPageResponse.getContent())) {
            return this.renderNoToken(url);
        }
        WikiInfoResponse wikiInfoResponse = this.azureRestClient.getWikiInfo(azureBaseUrl, acceptedConfiguration.getAuthorization().getPersonalAccessToken(), request);
        HashMap<String, String> model = new HashMap<String, String>();
        String html = this.markdownToHtml(wikiPageResponse.getContent());
        String attachmentUrl = String.format("%s/%s/%s/_apis/git/repositories/%s", azureBaseUrl, request.getOrganizationId(), request.getProjectName(), wikiInfoResponse.getRepositoryId());
        html = this.prepareImages(html, attachmentUrl, wikiPageResponse.getGitItemPath(), acceptedConfiguration.getAuthorization().getPersonalAccessToken());
        model.put("content", html);
        model.put("path", wikiPageResponse.getPath());
        model.put("url", url);
        return this.render(model, "templates/mwf-ado-wiki.vm");
    }

    private String markdownToHtml(String content) {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(AutolinkExtension.create(), TablesExtension.create(), AnchorLinkExtension.create(), TocExtension.create(), WikiLinkExtension.create(), StrikethroughExtension.create()));
        options.set(Parser.TRACK_DOCUMENT_LINES, (Object)true);
        options.set(Parser.WWW_AUTO_LINK_ELEMENT, (Object)true);
        options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
        options.set(TablesExtension.MIN_SEPARATOR_DASHES, (Object)2);
        options.set(TocExtension.LEVELS, (Object)6);
        options.set(TocExtension.DIV_CLASS, (Object)"toc-container");
        options.set(TocExtension.TITLE, (Object)"Contents");
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        Document document = parser.parse(this.prepareTOC(this.removeMermaidMarkups(content)));
        return renderer.render((Node)document);
    }

    private String prepareImages(String html, String attachmentsDir, String getGitItemPath, String token) {
        File file = new File(getGitItemPath);
        String relativePath = file.getParent();
        Pattern pattern = Pattern.compile("<img.*?src=\"[^http](.*?)\"");
        Matcher matcher = pattern.matcher(html);
        while (matcher.find()) {
            String toReplace = matcher.group(0);
            String imagePath = matcher.group(1);
            log.debug("Getting wiki image images: {}", (Object)imagePath);
            Object[] objectArray = new Object[2];
            objectArray[0] = attachmentsDir;
            Object object = objectArray[1] = imagePath.startsWith("/") ? imagePath : relativePath + imagePath;
            String imageUrl = String.format("%s/Items?path=%s", objectArray);
            byte[] bytes = this.azureRestClient.downloadImage(imageUrl, token);
            if (bytes == null) continue;
            String base64 = Base64.getEncoder().encodeToString(bytes);
            html = html.replace(toReplace, "<img src=\"data:image/jpeg;base64," + base64 + "\"");
        }
        return html;
    }

    public String getUrl(Map<String, String> parameters) {
        return parameters.get("link");
    }

    private String prepareTOC(String content) {
        return content.replace("[[_TOC_]]", "[TOC]");
    }

    private String removeMermaidMarkups(String content) {
        return content.replaceAll(":::.+\n?(?:.*\n)+:::", "");
    }
}

