/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.DelegateReleaseLinkHelper;
import com.moveworkforward.confluence.azure.link.ReleasesLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.ReleaseRequest;
import com.moveworkforward.confluence.azure.model.ReleaseResponse;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import com.moveworkforward.confluence.common.processor.Processor;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReleasesLinkProcessor
extends AbstractAzureLinkProcessor
implements Processor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReleasesLinkProcessor.class);

    @Inject
    public ReleasesLinkProcessor(CacheableAzureRestClient azureRestClient, AzureDevOpsSettingManager configurationService, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new DelegateReleaseLinkHelper());
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        String azureBaseUrl = this.getAzureHostUrl(parameters);
        String organizationID = this.getOrganization(parameters);
        String projectName = this.getProject(parameters);
        String id = ((AzureLinkHelper)this.linkHelper).getId(url);
        Integer limit = AzureMacroUtils.getIntegerValue(parameters, "itemsCount", null);
        ReleaseRequest request = new ReleaseRequest(organizationID, projectName, id, limit);
        List<Object> releases = new ArrayList();
        for (AzureConfiguration configuration : configurationsHolder.getConfigurations()) {
            log.debug("Get releases using: {}", (Object)configuration);
            try {
                ReleaseResponse release = null;
                if (((DelegateReleaseLinkHelper)this.linkHelper).getAccepted(url) instanceof ReleasesLinkHelper) {
                    releases = this.azureRestClient.getReleases(azureBaseUrl, configuration.getAuthorization().getPersonalAccessToken(), request).getValue();
                    if (!CollectionUtils.isNotEmpty(releases)) continue;
                    break;
                }
                release = this.azureRestClient.getRelease(azureBaseUrl, configuration.getAuthorization().getPersonalAccessToken(), request);
                if (release == null) continue;
                releases.add(release);
                break;
            }
            catch (Exception e) {
                log.warn("Can not get releases using configuration: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, releases);
        if (CollectionUtils.isEmpty(releases)) {
            return this.renderNoToken(url);
        }
        releases.forEach(r -> {
            if (CollectionUtils.isEmpty(r.getEnvironments())) {
                return;
            }
            r.getEnvironments().forEach(environment -> {
                String status = environment.getStatus();
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    status = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)status)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
                    environment.setStatus(status);
                }
            });
        });
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("releases", releases);
        model.put("spaceKey", parameters.get("spaceKey"));
        return this.render(model, "templates/mwf-ado-releases.vm");
    }
}

