/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.mapper;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.azure.rest.model.UserHolder;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;

@Mapper(componentModel="spring")
public class UserMapper {
    @ComponentImport
    @Inject
    private UserAccessor userAccessor;
    @ComponentImport
    @Inject
    private UserManager userManager;
    @ComponentImport
    @Inject
    private WebResourceUrlProvider webResourceUrlProvider;

    public String userToString(UserHolder user) {
        if (Objects.isNull(user)) {
            return null;
        }
        return user.getUserKey();
    }

    public UserHolder stringToUser(String userKey) {
        if (StringUtils.isBlank((CharSequence)userKey)) {
            return null;
        }
        UserHolder result = new UserHolder();
        result.setUserKey(userKey);
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        if (confluenceUser != null) {
            result.setUserName(confluenceUser.getName());
            result.setUserFullName(confluenceUser.getFullName());
            UserProfile userProfile = this.userManager.getUserProfile(confluenceUser.getName());
            if (userProfile != null && userProfile.getProfilePictureUri() != null) {
                URI pictureURI = userProfile.getProfilePictureUri();
                if (pictureURI.isAbsolute()) {
                    result.setLogoUrl(pictureURI.toString());
                } else {
                    result.setLogoUrl(this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE) + String.valueOf(pictureURI));
                }
            }
        }
        return result;
    }
}

