/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.ao.converters;

import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.v2.ao.PersistentConverter;
import com.moveworkforward.v2.model.BasePersistenceEntity;

public class AzureConfigurationConverter
implements PersistentConverter<BasePersistenceEntity, AzureConfiguration> {
    public BasePersistenceEntity convertToAo(AzureConfiguration target) {
        BasePersistenceEntity persistenceEntity = new BasePersistenceEntity();
        persistenceEntity.setID(target.getId() == null ? 0 : target.getId());
        persistenceEntity.setKey(target.getKey());
        persistenceEntity.setTag(AzureConfigurationConverter.getTag(target));
        persistenceEntity.setType("AZURE_CONFIGURATION_2");
        persistenceEntity.setContent(ConnectorUtil.createObjectMapper().writeValueAsString((Object)target));
        return persistenceEntity;
    }

    public static String getTag(AzureConfiguration target) {
        switch (target.getLevel()) {
            case GLOBAL: {
                return "05f11044-da77-41a8-ac66-a9388ffd0925";
            }
            case PERSONAL: {
                return target.getUserKey();
            }
            case SPACE: {
                return target.getSpaceKey();
            }
        }
        throw new RuntimeException("Unknown level: " + String.valueOf(target.getLevel()));
    }
}

