/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.actions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.service.AzureConfigurationService;
import com.moveworkforward.confluence.common.LicenseManager;
import com.moveworkforward.confluence.common.model.ConfigurationLevel;
import java.util.List;

public class SpaceViewConfigurationAction
extends SpaceAdminAction {
    private final PermissionManager permissionManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final LicenseManager licenseManager;
    private final AzureConfigurationService configurationService;

    public SpaceViewConfigurationAction(@ComponentImport PermissionManager permissionManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, LicenseManager licenseManager, AzureConfigurationService configurationService) {
        this.permissionManager = permissionManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.licenseManager = licenseManager;
        this.configurationService = configurationService;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.space);
    }

    public List<AzureConfiguration> getConfigurations() {
        return this.configurationService.getByTag(this.space.getKey(), ConfigurationLevel.SPACE.toString());
    }

    public boolean isLicenseValid() {
        return this.licenseManager.isLicensed();
    }

    public String getBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String execute() {
        return "success";
    }
}

