/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AzureDateTimeFormat {
    DATE_FORMAT_1("dd-mmm-yy", "dd-MMM-yy"),
    DATE_FORMAT_2("mm/dd/yyyy", "MM/dd/yyyy"),
    DATE_FORMAT_3("m/dd/yy", "M/dd/yy"),
    DATE_TIME_FORMAT_1("dddd, m/d/yy h:mm AM/PM", "EEEE, M/d/yy h:mm a"),
    DATE_TIME_FORMAT_2("ddd, mmmm dd, yyyy hh:mm:ss", "E, MMMM dd, yyyy HH:mm:ss"),
    NONE("none", "none"){

        @Override
        public String format(Date date) {
            return date == null ? "" : String.valueOf(date);
        }

        @Override
        public String formattedDate(String dateToFormat) {
            return StringUtils.isBlank((CharSequence)dateToFormat) ? "" : dateToFormat;
        }
    };

    @Generated
    private static final Logger log;
    private final String displayFormat;
    private final String javaFormat;
    public static final String[] DATE_PATTERNS;

    private AzureDateTimeFormat(String displayFormat, String javaFormat) {
        this.displayFormat = displayFormat;
        this.javaFormat = javaFormat;
    }

    public String formattedDate(String dateToFormat) {
        if (StringUtils.isBlank((CharSequence)dateToFormat)) {
            return "";
        }
        Date date = null;
        try {
            for (int i = 0; i < DATE_PATTERNS.length; ++i) {
                try {
                    date = new SimpleDateFormat(DATE_PATTERNS[i]).parse(dateToFormat);
                    break;
                }
                catch (Exception e) {
                    log.debug("Can not parse date: {} using format: {}", (Object)dateToFormat, (Object)DATE_PATTERNS[i]);
                    continue;
                }
            }
            if (date == null) {
                log.error("Can not parse, {}, no suitable format", (Object)dateToFormat);
                return dateToFormat;
            }
            return this.format(date);
        }
        catch (Exception e) {
            log.error("Can not parse: " + dateToFormat, (Throwable)e);
            return dateToFormat;
        }
    }

    public String format(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.javaFormat);
        return date == null ? "" : dateFormat.format(date);
    }

    @Generated
    public String getDisplayFormat() {
        return this.displayFormat;
    }

    @Generated
    public String getJavaFormat() {
        return this.javaFormat;
    }

    static {
        log = LoggerFactory.getLogger(AzureDateTimeFormat.class);
        DATE_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ssX"};
    }
}

