/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.component;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.ManagedCache;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.core.type.TypeReference;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="CacheableAzureRestClient")
public class CacheableAzureRestClient
extends AzureRestClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheableAzureRestClient.class);
    public static final int DEFAULT_MAX_ENTRIES = 10000;
    public static final long DEFAULT_EXPIRATION_IN_SECONDS = 600L;
    private static final String KEY_DELIMITER = "\u2020";
    protected CacheManager cacheManager;
    protected Cache<String, String> cache;
    protected CacheSettings cacheSettings;

    public CacheableAzureRestClient(@ComponentImport CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.cacheSettings = new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(10000).expireAfterWrite(600L, TimeUnit.SECONDS).build();
        this.cache = cacheManager.getCache(((Object)((Object)this)).getClass().getName() + ".azure-requests", this::loadValue, this.cacheSettings);
        this.cache.removeAll();
    }

    @Nonnull
    private String loadValue(String key) {
        String[] tokens = key.split(KEY_DELIMITER);
        String url = tokens[0];
        String token = tokens[1];
        String result = null;
        if (tokens.length > 2) {
            String payload = tokens[2];
            result = (String)super.postEntity(url, token, (Object)payload, (TypeReference)new TypeReference<String>(){});
        } else {
            result = (String)super.getEntity(url, token, (TypeReference)new TypeReference<String>(){});
        }
        return result == null ? "" : result;
    }

    protected <T> T getEntity(String url, String token, TypeReference<T> clazz) {
        String key = url + KEY_DELIMITER + token;
        String cachedValue = null;
        try {
            cachedValue = (String)this.cache.get((Object)key);
        }
        catch (CacheException e) {
            log.error("Can not get value from cache by key, cleaning cache", (Throwable)e);
            this.cache.remove((Object)key);
            cachedValue = (String)this.cache.get((Object)key);
        }
        if (StringUtils.isNotBlank((CharSequence)cachedValue)) {
            return (T)(clazz.getType().equals(String.class) ? cachedValue : this.objectMapper.readValue(cachedValue, clazz));
        }
        return null;
    }

    @Override
    public <T> T postEntity(String url, String token, Object payload, Class<T> clazz) {
        String payloadString = payload instanceof String ? (String)payload : this.objectMapper.writeValueAsString(payload);
        String key = url + KEY_DELIMITER + token + KEY_DELIMITER + payloadString;
        String cachedValue = (String)this.cache.get((Object)key);
        if (StringUtils.isNotBlank((CharSequence)cachedValue)) {
            return (T)(String.class.equals(clazz) ? cachedValue : this.objectMapper.readValue(cachedValue, clazz));
        }
        return null;
    }

    public synchronized void updateCacheConfiguration(int maxEntries, long expirationInSeconds) {
        long currentExpirationInSeconds = this.cacheSettings.getExpireAfterWrite(600000L) / 1000L;
        int currentMaxEntries = this.cacheSettings.getMaxEntries(10000);
        if (currentMaxEntries == maxEntries && currentExpirationInSeconds == expirationInSeconds) {
            log.debug("No cache update is required");
            return;
        }
        log.info("Old cache sizes:  {}", (Object)this.cache.getKeys().size());
        log.info("Previous settings: max entries {}, expiration {}", (Object)this.cacheSettings.getMaxEntries(), (Object)this.cacheSettings.getExpireAfterAccess());
        log.info("New settings: max entries {}, expiration {}(min)", (Object)maxEntries, (Object)expirationInSeconds);
        CacheSettings newCacheSettings = new CacheSettingsBuilder().remote().maxEntries(maxEntries).expireAfterWrite(expirationInSeconds, TimeUnit.SECONDS).replicateViaInvalidation().replicateAsynchronously().build();
        if (this.cache instanceof ManagedCache) {
            ((ManagedCache)this.cache).updateExpireAfterWrite(expirationInSeconds, TimeUnit.SECONDS);
            ((ManagedCache)this.cache).updateMaxEntries(maxEntries);
        } else {
            Cache newCache = this.cacheManager.getCache(((Object)((Object)this)).getClass().getName() + ".azure-requests", this::loadValue, newCacheSettings);
            Cache<String, String> oldCache = this.cache;
            this.cache = newCache;
            oldCache.removeAll();
        }
        this.cache.removeAll();
        this.cacheSettings = newCacheSettings;
    }
}

