/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.validation;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.validation.LevelPermissionConstraint;
import com.moveworkforward.confluence.azure.validation.SpacePermissionValidator;
import com.moveworkforward.confluence.common.model.ConfigurationLevel;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelPermissionValidator
implements ConstraintValidator<LevelPermissionConstraint, AzureConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LevelPermissionValidator.class);
    @ComponentImport
    @Inject
    private PermissionManager permissionManager;
    @ComponentImport
    @Inject
    private SpaceManager spaceManager;

    public boolean isValid(AzureConfiguration configuration, ConstraintValidatorContext context) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (SpacePermissionValidator.isGlobalAdmin(this.permissionManager, confluenceUser)) {
            return true;
        }
        if (ConfigurationLevel.PERSONAL.equals((Object)configuration.getLevel())) {
            return confluenceUser.getKey().getStringValue().equals(configuration.getUserKey());
        }
        if (ConfigurationLevel.SPACE.equals((Object)configuration.getLevel())) {
            Space space;
            if (StringUtils.isBlank((CharSequence)configuration.getSpaceKey())) {
                log.warn("{} level configuration doesn't have a spaceKey", (Object)configuration.getLevel());
            }
            if ((space = this.spaceManager.getSpace(configuration.getSpaceKey())) != null) {
                return this.permissionManager.hasPermission(confluenceUser, Permission.ADMINISTER, (Object)space);
            }
        }
        return false;
    }
}

