/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.entity.PluginSettingEntity;
import com.moveworkforward.ao.impl.AbstractPluginSettingRepository;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.old.AzureDevOpsConfiguration;
import com.moveworkforward.v2.ao.impl.AbstractPluginRepository;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeTask2
implements ActiveObjectsUpgradeTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask2.class);
    private final TransactionTemplate transactionTemplate;

    @Inject
    public UpgradeTask2(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        log.info("Migrate single configuration to multiple configurations V2");
        UpgradeTask2.migrate(activeObjects);
        OldAzureConfigurationRepository oldAzureConfigurationRepository = new OldAzureConfigurationRepository(activeObjects, this.transactionTemplate);
        NewAzureConfigurationRepository newAzureConfigurationRepository = new NewAzureConfigurationRepository(activeObjects, this.transactionTemplate);
        oldAzureConfigurationRepository.getAll().forEach(oldConfiguration -> {
            this.migrate((AzureDevOpsConfiguration)oldConfiguration, newAzureConfigurationRepository, true, true);
            if (StringUtils.isNotBlank((CharSequence)oldConfiguration.getConfiguration().getBaseUrl()) || StringUtils.isNotBlank((CharSequence)oldConfiguration.getConfiguration().getOrganization())) {
                this.migrate((AzureDevOpsConfiguration)oldConfiguration, newAzureConfigurationRepository, false, false);
            }
        });
    }

    private void migrate(AzureDevOpsConfiguration oldConfiguration, NewAzureConfigurationRepository newAzureConfigurationRepository, boolean setBaseUrl, boolean setOrganization) {
        AzureConfiguration configuration = new AzureConfiguration();
        configuration.setName("Configuration after migration, change me!");
        configuration.setLevel(oldConfiguration.getLevel());
        if (setBaseUrl) {
            configuration.setBaseUrl(oldConfiguration.getConfiguration().getBaseUrl());
        }
        if (setOrganization) {
            configuration.setOrganization(oldConfiguration.getConfiguration().getOrganization());
        }
        configuration.setUserKey(oldConfiguration.getUserKey());
        configuration.setSpaceKey(oldConfiguration.getSpaceKey());
        configuration.getAuthorization().setType(AzureConfiguration.AuthorizationType.PAT);
        configuration.getAuthorization().setPersonalAccessToken(oldConfiguration.getConfiguration().getPersonalAccessToken());
        newAzureConfigurationRepository.save(configuration);
        log.info("Configuration migrated, setBaseUrl: {}, setOrganization: {}", (Object)setBaseUrl, (Object)setOrganization);
    }

    public static void migrate(ActiveObjects activeObjects) {
        try {
            activeObjects.migrate(new Class[]{PluginSettingEntity.class});
        }
        catch (Throwable t) {
            log.error("Error migrating AO tables:: ", t);
        }
    }

    public static class OldAzureConfigurationRepository
    extends AbstractPluginSettingRepository<AzureDevOpsConfiguration> {
        public OldAzureConfigurationRepository(ActiveObjects activeObjects, TransactionTemplate transactionTemplate) {
            super(activeObjects, transactionTemplate);
        }
    }

    public static class NewAzureConfigurationRepository
    extends AbstractPluginRepository<PluginSettingEntity> {
        public NewAzureConfigurationRepository(ActiveObjects activeObjects, TransactionTemplate transactionTemplate) {
            super(activeObjects, transactionTemplate);
        }
    }
}

