/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.mapper;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.moveworkforward.confluence.azure.rest.model.SpaceHolder;
import jakarta.inject.Inject;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;

@Mapper(componentModel="spring")
public class SpaceMapper {
    @Inject
    private SpaceManager spaceManager;

    public String spaceToString(SpaceHolder space) {
        if (Objects.isNull(space)) {
            return null;
        }
        return space.getSpaceKey();
    }

    public SpaceHolder stringToSpace(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return null;
        }
        SpaceHolder result = new SpaceHolder();
        result.setSpaceKey(spaceKey);
        if ("05f11044-da77-41a8-ac66-a9388ffd0925".equals(spaceKey)) {
            result.setSpaceName("All spaces");
        } else {
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space != null) {
                result.setSpaceName(space.getName());
            }
        }
        return result;
    }
}

