/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.cloud;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.confluence.azure.ao.AzureRepository;
import com.moveworkforward.util.ConnectorUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class PluginDataMigrator
implements DiscoverableListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginDataMigrator.class);
    private final AzureRepository azureRepository;
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper((boolean)true);

    @Inject
    public PluginDataMigrator(AzureRepository azureRepository) {
        this.azureRepository = azureRepository;
    }

    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            log.info("Migration context summary: " + this.objectMapper.writeValueAsString((Object)migrationDetails));
            gateway.getCloudFeedbackIfPresent(transferId).ifPresent(it -> log.info("Cloud feedback found"));
        }
        catch (IOException e) {
            log.error("Error while running cloud migration", (Throwable)e);
        }
    }

    private void sendData(AppCloudMigrationGateway gateway, String transferId, String type, Supplier<?> dataSupplier) {
        try {
            OutputStream outputStream = gateway.createAppData(transferId, type);
            String payload = this.objectMapper.writeValueAsString(dataSupplier.get());
            outputStream.write(payload.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error("Error uploading files to the cloud, type: " + type, (Throwable)e);
        }
    }

    public String getCloudAppKey() {
        return "azure-devops-confluence-integration";
    }

    public String getServerAppKey() {
        return "azure-devops-confluence-integration";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

