/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.model.old;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.confluence.common.model.ConfigurationLevel;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.Source;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@EntityType(value="AZURE_CONFIGURATION")
@JsonIgnoreProperties(ignoreUnknown=true, value={"key", "tag"})
@JsonAutoDetect
public class AzureDevOpsConfiguration
extends AbstractPluginEntity
implements Cloneable {
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    public static final String DEFAULT_BASE_URL = "https://dev.azure.com";
    private String addonId = "azure-devops-confluence-integration";
    private Configuration configuration = new Configuration();
    private String key;
    private ConfigurationLevel level = ConfigurationLevel.GLOBAL;
    private String spaceKey;
    private String userKey;
    protected List<SourceEntity> sources = new ArrayList<SourceEntity>();

    public String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public String getTag() {
        switch (this.level) {
            case GLOBAL: {
                return ALL_SPACES;
            }
            case PERSONAL: {
                return this.userKey;
            }
            case SPACE: {
                return this.spaceKey;
            }
        }
        throw new RuntimeException("Unknown level: " + this.level);
    }

    public AzureDevOpsConfiguration clone() {
        try {
            AzureDevOpsConfiguration clone = (AzureDevOpsConfiguration)super.clone();
            clone.setConfiguration(this.getConfiguration().clone());
            clone.setSources((List<SourceEntity>)(this.getSources() == null ? null : new ArrayList<SourceEntity>(this.getSources())));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Generated
    public AzureDevOpsConfiguration() {
    }

    @Generated
    public String getAddonId() {
        return this.addonId;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public ConfigurationLevel getLevel() {
        return this.level;
    }

    @Generated
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Generated
    public String getUserKey() {
        return this.userKey;
    }

    @Generated
    public List<SourceEntity> getSources() {
        return this.sources;
    }

    @Generated
    public void setAddonId(String addonId) {
        this.addonId = addonId;
    }

    @Generated
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setLevel(ConfigurationLevel level) {
        this.level = level;
    }

    @Generated
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @Generated
    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    @Generated
    public void setSources(List<SourceEntity> sources) {
        this.sources = sources;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureDevOpsConfiguration)) {
            return false;
        }
        AzureDevOpsConfiguration other = (AzureDevOpsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AzureDevOpsConfiguration;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public String toString() {
        return "AzureDevOpsConfiguration(super=" + super.toString() + ", addonId=" + this.getAddonId() + ", key=" + this.getKey() + ", level=" + this.getLevel() + ", spaceKey=" + this.getSpaceKey() + ", userKey=" + this.getUserKey() + ", sources=" + this.getSources() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonAutoDetect
    public static class Configuration
    implements Serializable,
    Cloneable {
        private String personalAccessToken;
        private String baseUrl = "https://dev.azure.com";
        private boolean useBaseUrl;
        private String organization;
        private boolean useOrganization;

        public Configuration clone() {
            try {
                return (Configuration)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        @Generated
        public Configuration() {
        }

        @Generated
        public String getPersonalAccessToken() {
            return this.personalAccessToken;
        }

        @Generated
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Generated
        public boolean isUseBaseUrl() {
            return this.useBaseUrl;
        }

        @Generated
        public String getOrganization() {
            return this.organization;
        }

        @Generated
        public boolean isUseOrganization() {
            return this.useOrganization;
        }

        @Generated
        public void setPersonalAccessToken(String personalAccessToken) {
            this.personalAccessToken = personalAccessToken;
        }

        @Generated
        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Generated
        public void setUseBaseUrl(boolean useBaseUrl) {
            this.useBaseUrl = useBaseUrl;
        }

        @Generated
        public void setOrganization(String organization) {
            this.organization = organization;
        }

        @Generated
        public void setUseOrganization(boolean useOrganization) {
            this.useOrganization = useOrganization;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUseBaseUrl() != other.isUseBaseUrl()) {
                return false;
            }
            if (this.isUseOrganization() != other.isUseOrganization()) {
                return false;
            }
            String this$personalAccessToken = this.getPersonalAccessToken();
            String other$personalAccessToken = other.getPersonalAccessToken();
            if (this$personalAccessToken == null ? other$personalAccessToken != null : !this$personalAccessToken.equals(other$personalAccessToken)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
                return false;
            }
            String this$organization = this.getOrganization();
            String other$organization = other.getOrganization();
            return !(this$organization == null ? other$organization != null : !this$organization.equals(other$organization));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseBaseUrl() ? 79 : 97);
            result = result * 59 + (this.isUseOrganization() ? 79 : 97);
            String $personalAccessToken = this.getPersonalAccessToken();
            result = result * 59 + ($personalAccessToken == null ? 43 : $personalAccessToken.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            String $organization = this.getOrganization();
            result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AzureDevOpsConfiguration.Configuration(baseUrl=" + this.getBaseUrl() + ", useBaseUrl=" + this.isUseBaseUrl() + ", organization=" + this.getOrganization() + ", useOrganization=" + this.isUseOrganization() + ")";
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SourceEntity
    implements Source {
        private String spaceKey;

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }

        @Generated
        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceEntity)) {
                return false;
            }
            SourceEntity other = (SourceEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$spaceKey = this.getSpaceKey();
            String other$spaceKey = other.getSpaceKey();
            return !(this$spaceKey == null ? other$spaceKey != null : !this$spaceKey.equals(other$spaceKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SourceEntity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $spaceKey = this.getSpaceKey();
            result = result * 59 + ($spaceKey == null ? 43 : $spaceKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AzureDevOpsConfiguration.SourceEntity(spaceKey=" + this.getSpaceKey() + ")";
        }

        @Generated
        public SourceEntity() {
        }

        @Generated
        public SourceEntity(String spaceKey) {
            this.spaceKey = spaceKey;
        }
    }
}

