/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SearchWorkItemsProcessor
extends AbstractAzureLinkProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchWorkItemsProcessor.class);

    @Inject
    protected SearchWorkItemsProcessor(CacheableAzureRestClient azureRestClient, AzureDevOpsSettingManager configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new AbstractLinkHelper(){

            @Override
            public String getKeyPath() {
                return "";
            }
        });
    }

    public boolean canProcess(Map<String, String> parameters) {
        String url = this.getUrl(parameters);
        return url != null && url.startsWith("http") && StringUtils.isNotBlank((CharSequence)this.getOrganization(parameters)) && StringUtils.isNotBlank((CharSequence)parameters.get("searchText"));
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        for (AzureConfiguration configuration : configurationsHolder.getConfigurations()) {
            log.debug("Search work items using: {}", (Object)configuration);
            try {
                String url = this.getUrl(parameters);
                boolean hideHeader = Boolean.parseBoolean(parameters.get("hideHeader"));
                int limit = AzureMacroUtils.getIntegerValue(parameters, "itemsCount", -1);
                int recordsPerPage = AzureMacroUtils.getIntegerValue(parameters, "recordsPerPage", 10);
                String organizationID = this.getOrganization(parameters);
                String projectName = this.getProject(parameters);
                String searchText = parameters.get("searchText");
                HashMap<String, Object> model = new HashMap<String, Object>();
                Set<String> fieldsToDisplay = AzureMacroUtils.getFieldsToDisplay(parameters);
                String token = configuration.getAuthorization().getPersonalAccessToken();
                Map<String, FieldsResponse.Field> allFields = AzureMacroUtils.getAllFields(this.azureRestClient, url, token, organizationID, projectName, null);
                if (allFields == null) continue;
                model.put("url", url);
                model.put("searchText", searchText);
                model.put("limit", limit);
                model.put("organization", organizationID);
                model.put("project", projectName);
                model.put("fieldsToDisplay", fieldsToDisplay);
                model.put("allFields", allFields);
                model.put("hideHeader", hideHeader);
                model.put("recordsPerPage", recordsPerPage);
                model.put("baseUrl", this.getBaseUrl());
                model.put("macro", "search");
                model.put("spaceKey", parameters.get("spaceKey"));
                model.put("macroName", this.i18nResolver.getText("azure-devops-confluence-integration.azure-devops-search-work-items.label"));
                model.put("uuid", UUID.randomUUID().toString());
                model.put("paginationUrl", this.getBaseUrl() + "/rest/azure-devops/1.0/macro/search");
                return this.render(model, "templates/mwf-ado-paginated-work-items.vm");
            }
            catch (Exception e) {
                log.warn("Can not process search work items using configuration: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
            }
        }
        return this.renderNoToken(parameters.getOrDefault("url", "Unknown"));
    }

    @Override
    public String getAzureHostUrl(Map<String, String> parameters) {
        return this.getUrl(parameters);
    }

    @Override
    public String getAzureOriginalHostUrl(Map<String, String> parameters) {
        return this.getUrl(parameters);
    }

    @Override
    public String getOrganization(Map<String, String> parameters) {
        return parameters.get("organization");
    }

    @Override
    public String getProject(Map<String, String> parameters) {
        return parameters.get("project");
    }
}

