/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.actions;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.service.AzureConfigurationService;
import com.moveworkforward.confluence.common.LicenseManager;
import com.moveworkforward.confluence.common.model.ConfigurationLevel;
import java.util.List;

public class PersonalViewConfigurationAction
extends AbstractUserProfileAction {
    private final PermissionManager permissionManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final LicenseManager licenseManager;
    private final AzureConfigurationService configurationService;

    public PersonalViewConfigurationAction(@ComponentImport PermissionManager permissionManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, LicenseManager licenseManager, AzureConfigurationService configurationService) {
        this.permissionManager = permissionManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.licenseManager = licenseManager;
        this.configurationService = configurationService;
    }

    public List<AzureConfiguration> getConfigurations() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.configurationService.getByTag(user.getKey().getStringValue(), ConfigurationLevel.PERSONAL.toString());
    }

    public boolean isLicenseValid() {
        return this.licenseManager.isLicensed();
    }

    public String getBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String execute() {
        return "success";
    }
}

