/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.rest;

import com.moveworkforward.confluence.azure.model.AzureDateTimeFormat;
import com.moveworkforward.confluence.azure.model.AzureGlobalSettings;
import com.moveworkforward.confluence.azure.service.AzureGlobalSettingsService;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/global-settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class AzureGlobalSettingsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureGlobalSettingsController.class);
    private final AzureGlobalSettingsService globalSettingsService;

    @Inject
    public AzureGlobalSettingsController(AzureGlobalSettingsService globalSettingsService) {
        this.globalSettingsService = globalSettingsService;
    }

    @GET
    public AzureGlobalSettings get() {
        return this.globalSettingsService.get();
    }

    @POST
    public AzureGlobalSettings save(AzureGlobalSettings globalSettings) {
        return this.globalSettingsService.save(globalSettings);
    }

    @GET
    @Path(value="/datetime/formats")
    public Map<AzureDateTimeFormat, String> getDateTimeFormats() {
        return Arrays.stream(AzureDateTimeFormat.values()).collect(Collectors.toMap(dateTimeFormat -> dateTimeFormat, AzureDateTimeFormat::getDisplayFormat));
    }
}

