/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.component;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.confluence.azure.model.BuildStatusResponse;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.QueryCountResponse;
import com.moveworkforward.confluence.azure.model.QueryRequest;
import com.moveworkforward.confluence.azure.model.QueryResponse;
import com.moveworkforward.confluence.azure.model.ReleaseRequest;
import com.moveworkforward.confluence.azure.model.ReleaseResponse;
import com.moveworkforward.confluence.azure.model.ReleasesResponse;
import com.moveworkforward.confluence.azure.model.SearchRequest;
import com.moveworkforward.confluence.azure.model.SearchResponse;
import com.moveworkforward.confluence.azure.model.WikiInfoResponse;
import com.moveworkforward.confluence.azure.model.WikiPageResponse;
import com.moveworkforward.confluence.azure.model.WikiRequest;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.common.rest.AbstractRestClient;
import com.moveworkforward.util.ConnectorUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="AzureRestClient")
public class AzureRestClient
extends AbstractRestClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureRestClient.class);
    private static final int DEFAULT_ERROR_MESSAGE_LENGTH = 3000;
    protected final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper((boolean)true);

    public FieldsResponse getFields(String baseUrl, String token, GeneralRequest request) {
        String organizationProjectContext = this.preparePathValue(request.getOrganizationId()) + (String)(StringUtils.isBlank((CharSequence)request.getProjectName()) ? "" : "/" + this.preparePathValue(request.getProjectName()));
        String url = String.format("%s/%s/_apis/wit/fields", baseUrl, organizationProjectContext);
        FieldsResponse fieldsResponse = (FieldsResponse)this.getEntity(url, token, (TypeReference)new TypeReference<FieldsResponse>(){});
        fieldsResponse.getValue().removeIf(field -> !"workItem".equals(field.getUsage()));
        return fieldsResponse;
    }

    public WorkItemResponse getWorkItem(String baseUrl, String token, GeneralRequest workItemRequest) {
        String url = String.format("%s/%s/%s/_apis/wit/workitems/%s", baseUrl, workItemRequest.getOrganizationId(), workItemRequest.getProjectName(), workItemRequest.getId());
        return (WorkItemResponse)this.getEntity(url, token, (TypeReference)new TypeReference<WorkItemResponse>(){});
    }

    private Header getLocationHeader(HttpResponse response) {
        Header header = null;
        if (response.containsHeader("Location")) {
            header = response.getFirstHeader("Location");
        } else if (response.containsHeader("location")) {
            header = response.getFirstHeader("location");
        }
        return header;
    }

    private <T> T redirect(String url, Header header, String token, HttpRequestBase request, TypeReference<T> clazz) {
        log.warn("Resource was moved from {}, trying to reach it out", (Object)url);
        if (header == null || StringUtils.isBlank((CharSequence)header.getValue())) {
            log.warn("No location header");
            return null;
        }
        if (url.equals(header.getValue())) {
            log.error("Redirection to the same url: {}", (Object)url);
            return null;
        }
        url = header.getValue();
        log.warn("New resource location is {}", (Object)url);
        request.setURI(URI.create(url));
        return (T)super.executeRequest(url, token, request, clazz);
    }

    protected <T> T processErrorResponse(String url, String token, int statusCode, String content, HttpRequestBase request, HttpResponse response, TypeReference<T> clazz) {
        if (statusCode >= 300 && statusCode < 400) {
            T result = this.redirect(url, this.getLocationHeader(response), token, request, clazz);
            if (result == null) {
                this.logErrorResponse(url, statusCode, content);
            }
            return result;
        }
        if (statusCode >= 400) {
            this.logErrorResponse(url, statusCode, content);
            return null;
        }
        return (T)(clazz.getType().equals(String.class) ? content : this.objectMapper.readValue(content, clazz));
    }

    protected void processHeaders(String url, String token, HttpRequestBase request) {
        String auth = ":" + token;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
        String authHeader = "Basic " + new String(encodedAuth);
        request.setHeader("Authorization", authHeader);
    }

    <T> T postEntity(String url, String token, Object payload, Class<T> clazz) {
        return (T)super.postEntity(url, token, payload, new TypeReference<T>(){});
    }

    public SearchResponse searchItems(String baseUrl, String token, SearchRequest searchRequest) {
        String organizationProjectContext = this.preparePathValue(searchRequest.getOrganizationId()) + (String)(StringUtils.isBlank((CharSequence)searchRequest.getProjectName()) ? "" : "/" + this.preparePathValue(searchRequest.getProjectName()));
        Object url = String.format("%s/%s/_apis/wit/wiql?timePrecision=true&api-version=6.0", baseUrl, organizationProjectContext);
        if (searchRequest.getLimit() != null && searchRequest.getLimit() > 0) {
            url = (String)url + "&$top=" + searchRequest.getLimit();
        }
        log.info("Query: {}", (Object)searchRequest.getQuery());
        SearchResponse searchResponse = this.postEntity((String)url, token, searchRequest, SearchResponse.class);
        if (searchResponse == null) {
            return null;
        }
        int page = searchRequest.getPage();
        int recordsPerPage = searchRequest.getRecordsPerPage();
        ArrayList<WorkItemResponse> workitemSet = new ArrayList<WorkItemResponse>(new LinkedHashSet<WorkItemResponse>(searchResponse.getWorkItems()));
        ArrayList<WorkItemResponse> workItemResponses = workitemSet.size() <= recordsPerPage * page ? new ArrayList<WorkItemResponse>() : workitemSet.subList(page * recordsPerPage, Math.min(workitemSet.size(), page * recordsPerPage + recordsPerPage)).stream().map(w -> (WorkItemResponse)this.getEntity(w.getUrl(), token, (TypeReference)new TypeReference<WorkItemResponse>(){})).collect(Collectors.toList());
        return new SearchResponse(workItemResponses, workitemSet.size(), page);
    }

    public QueryCountResponse getQueryWorkItemsCount(String baseUrl, String token, QueryRequest queryRequest) {
        Map queryResult;
        ArrayList<Map> workitemMaps;
        Object url = String.format("%s/%s/%s/_apis/wit/queries/%s", baseUrl, queryRequest.getOrganizationId(), queryRequest.getProjectName(), queryRequest.getId());
        QueryResponse queryResponse = (QueryResponse)this.getEntity((String)url, token, (TypeReference)new TypeReference<QueryResponse>(){});
        if (queryResponse == null) {
            return null;
        }
        url = queryResponse.getLinks().getWiql().getHref();
        if (queryRequest.getLimit() != null) {
            url = (String)url + "?$top=" + queryRequest.getLimit();
        }
        if ((workitemMaps = (ArrayList<Map>)(queryResult = (Map)this.getEntity((String)url, token, (TypeReference)new TypeReference<Map<String, Object>>(){})).get("workItems")) == null) {
            if (queryResult.containsKey("workItemRelations")) {
                workitemMaps = new ArrayList<Map>();
                List workItemRelations = (List)queryResult.get("workItemRelations");
                for (Map workItemRelation : workItemRelations) {
                    Map workItem = (Map)workItemRelation.get("source");
                    if (workItem != null) {
                        workitemMaps.add(workItem);
                    }
                    if ((workItem = (Map)workItemRelation.get("target")) == null) continue;
                    workitemMaps.add(workItem);
                }
            } else {
                throw new RuntimeException("Unsupported type of query");
            }
        }
        LinkedHashSet workitemSet = new LinkedHashSet(workitemMaps);
        return new QueryCountResponse(queryResponse.getId(), queryResponse.getName(), workitemSet.size());
    }

    public QueryResponse getQuery(String baseUrl, String token, QueryRequest queryRequest) {
        Map queryResult;
        ArrayList<Map> workitemMaps;
        Object url = String.format("%s/%s/%s/_apis/wit/queries/%s", baseUrl, queryRequest.getOrganizationId(), queryRequest.getProjectName(), queryRequest.getId());
        QueryResponse queryResponse = (QueryResponse)this.getEntity((String)url, token, (TypeReference)new TypeReference<QueryResponse>(){});
        if (queryResponse == null) {
            return null;
        }
        url = queryResponse.getLinks().getWiql().getHref();
        if (queryRequest.getLimit() != null && queryRequest.getLimit() > 0) {
            url = (String)url + "?$top=" + queryRequest.getLimit();
        }
        if ((workitemMaps = (ArrayList<Map>)(queryResult = (Map)this.getEntity((String)url, token, (TypeReference)new TypeReference<Map<String, Object>>(){})).get("workItems")) == null) {
            if (queryResult.containsKey("workItemRelations")) {
                workitemMaps = new ArrayList<Map>();
                List workItemRelations = (List)queryResult.get("workItemRelations");
                for (Map workItemRelation : workItemRelations) {
                    Map workItem = (Map)workItemRelation.get("source");
                    if (workItem != null) {
                        workitemMaps.add(workItem);
                    }
                    if ((workItem = (Map)workItemRelation.get("target")) == null) continue;
                    workitemMaps.add(workItem);
                }
            } else {
                throw new RuntimeException("Unsupported type of query, result: " + queryResult);
            }
        }
        int page = queryRequest.getPage();
        int recordsPerPage = queryRequest.getRecordsPerPage();
        ArrayList workitemSet = new ArrayList(new LinkedHashSet(workitemMaps));
        ArrayList workItemResponses = workitemSet.size() <= recordsPerPage * page ? new ArrayList() : workitemSet.subList(page * recordsPerPage, Math.min(workitemSet.size(), page * recordsPerPage + recordsPerPage)).stream().map(m -> (WorkItemResponse)this.getEntity((String)m.get("url"), token, (TypeReference)new TypeReference<WorkItemResponse>(){})).collect(Collectors.toList());
        queryResponse.setWorkItems(new ArrayList<WorkItemResponse>(new LinkedHashSet(workItemResponses)));
        queryResponse.setTotal(workitemSet.size());
        queryResponse.setPage(page);
        return queryResponse;
    }

    public WikiPageResponse getWikiPage(String baseUrl, String token, WikiRequest wikiRequest) {
        String url = String.format("%s/%s/%s/_apis/wiki/wikis/%s/pages/%s?includeContent=true", baseUrl, wikiRequest.getOrganizationId(), wikiRequest.getProjectName(), wikiRequest.getWikiIdentifier(), wikiRequest.getId());
        return (WikiPageResponse)this.getEntity(url, token, (TypeReference)new TypeReference<WikiPageResponse>(){});
    }

    public WikiInfoResponse getWikiInfo(String baseUrl, String token, WikiRequest wikiRequest) {
        String url = String.format("%s/%s/%s/_apis/wiki/wikis/%s", baseUrl, wikiRequest.getOrganizationId(), wikiRequest.getProjectName(), wikiRequest.getWikiIdentifier());
        return (WikiInfoResponse)this.getEntity(url, token, (TypeReference)new TypeReference<WikiInfoResponse>(){});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] downloadImage(String url, String token) {
        HttpGet request = new HttpGet(url);
        byte[] content = null;
        int statusCode = 0;
        try {
            log.debug("URL: {}", (Object)url);
            try (CloseableHttpClient client = this.createClient();){
                boolean imageType;
                this.processHeaders(url, token, (HttpRequestBase)request);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                content = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                statusCode = response.getStatusLine().getStatusCode();
                log.debug("Status code: {}", (Object)statusCode);
                log.debug("Content length: {}", (Object)content.length);
                if (statusCode != 200) {
                    this.logErrorResponse(url, statusCode, "Bad response code");
                }
                if (!(imageType = Stream.of(response.getHeaders("content-type")).anyMatch(header -> header.getValue().contains("image")))) {
                    this.logErrorResponse(url, statusCode, "Invalid image content type: " + Arrays.toString(response.getHeaders("content-type")));
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = content;
                return byArray;
            }
        }
        catch (Exception e) {
            this.logErrorResponse(url, statusCode, e.getMessage());
            String errorText = Stream.of(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            log.error(e.getMessage() + ", \n stacktrace: " + errorText.substring(0, Math.min(errorText.length(), 3000)));
            throw e;
        }
    }

    public BuildStatusResponse getBuildStatus(String baseUrl, String token, GeneralRequest buildsRequest) {
        String url = String.format("%s/%s/%s/_apis/build/Builds?definitions=%s&maxBuildsPerDefinition=1", baseUrl, buildsRequest.getOrganizationId(), buildsRequest.getProjectName(), buildsRequest.getId());
        BuildStatusResponse response = (BuildStatusResponse)this.getEntity(url, token, (TypeReference)new TypeReference<BuildStatusResponse>(){});
        if (response != null && CollectionUtils.isNotEmpty(response.getValue())) {
            for (BuildStatusResponse.BuildStatus buildStatus : response.getValue()) {
                buildStatus.setProject((BuildStatusResponse.Project)this.getEntity(buildStatus.getProject().getUrl(), token, (TypeReference)new TypeReference<BuildStatusResponse.Project>(){}));
                buildStatus.setDefinition((BuildStatusResponse.Definition)this.getEntity(buildStatus.getDefinition().getUrl(), token, (TypeReference)new TypeReference<BuildStatusResponse.Definition>(){}));
            }
        }
        return response;
    }

    public ReleasesResponse getReleases(String baseUrl, String token, ReleaseRequest request) {
        Object url = String.format("%s/%s/%s/_apis/release/releases?$expand=environments&definitionId=%s", baseUrl, request.getOrganizationId(), request.getProjectName(), request.getId());
        if (request.getLimit() != null && request.getLimit() > 0) {
            url = (String)url + "&$top=" + request.getLimit();
        }
        ReleasesResponse response = (ReleasesResponse)this.getEntity((String)url, token, (TypeReference)new TypeReference<ReleasesResponse>(){});
        return response;
    }

    public ReleaseResponse getRelease(String baseUrl, String token, GeneralRequest request) {
        String url = String.format("%s/%s/%s/_apis/Release/releases/%s", baseUrl, request.getOrganizationId(), request.getProjectName(), request.getId());
        ReleaseResponse response = (ReleaseResponse)this.getEntity(url, token, (TypeReference)new TypeReference<ReleaseResponse>(){});
        return response;
    }

    private String preparePathValue(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && value.contains(" ") ? URIUtil.encodePath((String)value) : value;
    }
}

