/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.rest;

import com.moveworkforward.confluence.azure.mapper.ConfigurationMapper;
import com.moveworkforward.confluence.azure.mapper.PaginationResponseMapper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.PaginationResponse;
import com.moveworkforward.confluence.azure.rest.model.AzureRestConfiguration;
import com.moveworkforward.confluence.azure.rest.model.PaginationRestResponse;
import com.moveworkforward.confluence.azure.service.AzureConfigurationService;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class AzureConfigurationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureConfigurationController.class);
    private final AzureConfigurationService configurationService;
    private final ConfigurationMapper configurationMapper;
    private final PaginationResponseMapper paginationResponseMapper;

    @Inject
    public AzureConfigurationController(AzureConfigurationService configurationService, ConfigurationMapper configurationMapper, PaginationResponseMapper paginationResponseMapper) {
        this.configurationService = configurationService;
        this.configurationMapper = configurationMapper;
        this.paginationResponseMapper = paginationResponseMapper;
    }

    @GET
    public PaginationRestResponse getConfigurations(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        log.debug("Get configurations for spaceKey: {}", (Object)spaceKey);
        PaginationResponse response = this.configurationService.getConfigurations(spaceKey, start, limit);
        return this.paginationResponseMapper.responseToRest(response);
    }

    @Path(value="/{id}")
    @GET
    public AzureRestConfiguration getConfiguration(@PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        return this.configurationMapper.configurationCtrlToRest((AzureConfiguration)this.configurationService.get(id));
    }

    @POST
    public AzureRestConfiguration saveConfiguration(AzureRestConfiguration configuration) {
        log.debug("Saving: " + configuration.toString());
        AzureConfiguration savedConfiguration = (AzureConfiguration)this.configurationService.save(this.configurationMapper.configurationRestToCtrl(configuration));
        return this.configurationMapper.configurationCtrlToRest(savedConfiguration);
    }

    @Path(value="/{id}")
    @PUT
    public AzureRestConfiguration updateConfiguration(@PathParam(value="id") Integer id, AzureRestConfiguration configuration) {
        configuration.setId(id);
        log.debug("Updating: " + configuration);
        this.configurationService.get(id);
        AzureConfiguration savedConfiguration = (AzureConfiguration)this.configurationService.save(this.configurationMapper.configurationRestToCtrl(configuration));
        return this.configurationMapper.configurationCtrlToRest(savedConfiguration);
    }

    @Path(value="/{id}")
    @DELETE
    public void deleteConfiguration(@PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        this.configurationService.delete(id);
    }

    @GET
    @Path(value="/personal")
    public PaginationRestResponse getPersonal(@QueryParam(value="userKey") String userKey, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        log.debug("Get configurations for user: {}", (Object)userKey);
        PaginationResponse response = this.configurationService.getPersonalConfigurations(userKey, start, limit);
        return this.paginationResponseMapper.responseToRest(response);
    }
}

