define('moveworkforward/azure/autoconvert', ['tinymce'], function (tinymce) {
    "use strict";
    //java code adapted to javascript************
    function isAccepted(uri, keyPath) {
        var parts = uri.source.split('/');

        if(isOldApi(uri)) {
            return isOldUrlAccepted(parts, keyPath);
        } else if (isAzureUrl(uri)) {
            return isNewUrlAccepted(parts, keyPath);
          }
    }

    function isAzureUrl(uri) {
        return uri.host === "dev.azure.com";
    }

    function isOldApi(uri) {
        return uri.host.endsWith("visualstudio.com");
    }

    function isOldUrlAccepted(parts, keyPath) {
        return isUrlAccepted(parts, 4, keyPath);
    }

    function isNewUrlAccepted(parts, keyPath) {
       return isUrlAccepted(parts, 5, keyPath);
    }

    function isUrlAccepted(parts, expectedIndex, keyPath){
       var index = parts.indexOf(keyPath);
       var protocols = ["http:", "https:"]
       return protocols.includes(parts[0])
             && index >= expectedIndex
             && parts.length > index + 2;
    }
    //**************

    function AzureDevOpsConverter() {
        function pasteHandler(uri, node, done) {
            var azureMacro;
            if(isAccepted(uri, "_workitems")) {
                 azureMacro = "azure-devops-work-item-link";
            } else if(isAccepted(uri, "_queries")) {
                 azureMacro = "azure-devops-query-link";
            } else if(isAccepted(uri, "_sprints")) {
                 azureMacro = "azure-devops-work-item-link";
            }

            if (typeof azureMacro !== 'undefined' && azureMacro !== null && node.text() === uri.source) {
                var actualUrl = uri.source;
                if(actualUrl.indexOf("workitem=") > 0) {
                    actualUrl = actualUrl.replace("workitem=", "workitem\\=");
                }
                var hash = btoa("{" + azureMacro + ":url=" + actualUrl +"}");
                node.html('<img class="editor-inline-macro" src="/confluence/plugins/servlet/confluence/placeholder/macro?definition='
                 + hash +'&amp;locale=en_En&amp;version=2" data-macro-name="' + azureMacro
                  + '" data-macro-parameters="url='+ actualUrl + '" data-macro-schema-version="1" />');
                done(node);
            } else {
                done();
            }
        }

        tinymce.plugins.Autoconvert.autoConvert.addHandler(pasteHandler);
    }

    return AzureDevOpsConverter;
});

require('confluence/module-exporter').safeRequire('moveworkforward/azure/autoconvert', function (AzureDevOpsConverter) {
    require('ajs').bind("init.rte", AzureDevOpsConverter);
});