/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.validator;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.confluence.azure.component.ValidationConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.v2.validation.AbstractRecordValidator;
import jakarta.validation.Validator;
import java.util.Optional;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AzureRecordValidator
extends AbstractRecordValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureRecordValidator.class);
    protected final PermissionManager permissionManager;
    protected final SpaceManager spaceManager;

    @Inject
    public AzureRecordValidator(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    protected Validator getValidator() {
        return ValidationConfiguration.getValidator();
    }

    public com.moveworkforward.model.User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return Optional.ofNullable(confluenceUser).map(u -> new com.moveworkforward.model.User(u, u.getKey().getStringValue(), u.getFullName())).orElse(new com.moveworkforward.model.User());
    }

    public boolean isGlobalAdmin(com.moveworkforward.model.User user) {
        return this.permissionManager.isConfluenceAdministrator((User)user.getUser());
    }

    public boolean hasTagPermission(String tag, String level) {
        com.moveworkforward.model.User user = this.getCurrentUser();
        if (this.isGlobalAdmin(user)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            return false;
        }
        if (AzureConfiguration.Level.SPACE.toString().equals(level)) {
            Space space = this.spaceManager.getSpace(tag);
            if (space != null) {
                return this.permissionManager.hasPermission((User)user.getUser(), Permission.ADMINISTER, (Object)space);
            }
        } else if (AzureConfiguration.Level.PERSONAL.toString().equals(level)) {
            return user.getUserKey().equals(tag);
        }
        return false;
    }
}

