/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.DelegateWorkItemLinkHelper;
import com.moveworkforward.confluence.azure.link.QueryLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.SearchConfigurationParameters;
import com.moveworkforward.confluence.azure.processor.SearchWorkItemsProcessor;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/work-items")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class WorkItemFieldsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkItemFieldsController.class);
    public static final String SEARCH_WORK_ITEMS_LINK = "azure-devops-search-work-items";
    public static final String WORK_ITEM_ID = "System.Id";
    public static final Map<String, AzureLinkHelper> LINK_HELPERS = new LinkedHashMap<String, AzureLinkHelper>(){
        {
            this.put("azure-devops-query-link", new QueryLinkHelper());
            this.put("azure-devops-work-item-link", new DelegateWorkItemLinkHelper());
            this.put("azure-devops-link", new DelegateWorkItemLinkHelper());
            this.put(WorkItemFieldsController.SEARCH_WORK_ITEMS_LINK, new AbstractLinkHelper(){

                @Override
                public String getKeyPath() {
                    return "";
                }
            });
        }
    };
    public static final Map<String, FieldsResponse.Field> DEFAULT_PARAMETERS = new LinkedHashMap<String, FieldsResponse.Field>(){
        {
            this.put("System.WorkItemType", new FieldsResponse.Field("System.WorkItemType", "Work Item Type"));
            this.put("System.Title", new FieldsResponse.Field("System.Title", "Title"));
            this.put("System.State", new FieldsResponse.Field("System.State", "State"));
            this.put("System.AssignedTo", new FieldsResponse.Field("System.AssignedTo", "Assigned To"));
        }
    };
    private final AzureRestClient azureRestClient;
    private final MacroConfigurationService<AzureConfigurationsHolder, SearchConfigurationParameters> configurationService;
    private final SearchWorkItemsProcessor searchWorkItemsProcessor;

    @Inject
    public WorkItemFieldsController(CacheableAzureRestClient azureRestClient, AzureDevOpsSettingManager configurationService, SearchWorkItemsProcessor searchWorkItemsProcessor) {
        this.azureRestClient = azureRestClient;
        this.configurationService = configurationService;
        this.searchWorkItemsProcessor = searchWorkItemsProcessor;
    }

    @POST
    @Path(value="/fields")
    public Map<String, FieldsResponse.Field> getFields(FieldsRequest fieldsRequest) {
        try {
            if (StringUtils.isBlank((CharSequence)fieldsRequest.getKey()) || !LINK_HELPERS.containsKey(fieldsRequest.getKey())) {
                return DEFAULT_PARAMETERS;
            }
            String azureHostUrl = null;
            String organization = null;
            if (SEARCH_WORK_ITEMS_LINK.equals(fieldsRequest.getKey())) {
                azureHostUrl = this.searchWorkItemsProcessor.getAzureHostUrl(fieldsRequest.getParameters());
                organization = this.searchWorkItemsProcessor.getOrganization(fieldsRequest.getParameters());
            } else {
                String url;
                AzureLinkHelper linkHelper = LINK_HELPERS.get(fieldsRequest.getKey());
                if (!linkHelper.isAccepted(url = fieldsRequest.getParameters().get("url"))) {
                    return DEFAULT_PARAMETERS;
                }
                azureHostUrl = linkHelper.getBaseUrl(url);
                organization = linkHelper.getOrganizationID(url);
            }
            SearchConfigurationParameters configurationParameters = new SearchConfigurationParameters(azureHostUrl, organization, fieldsRequest.getSpaceKey());
            AzureConfigurationsHolder configurationsHolder = (AzureConfigurationsHolder)this.configurationService.get((Object)configurationParameters);
            if (configurationsHolder.isEmpty()) {
                return DEFAULT_PARAMETERS;
            }
            for (AzureConfiguration configuration : configurationsHolder.getConfigurations()) {
                log.debug("Get fields using {}", (Object)configuration);
                try {
                    return this.doGetFields(fieldsRequest, configuration);
                }
                catch (Exception e) {
                    log.warn("Can not get fields using configuration: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return DEFAULT_PARAMETERS;
    }

    private Map<String, FieldsResponse.Field> doGetFields(FieldsRequest fieldsRequest, AzureConfiguration configuration) {
        String url;
        AzureLinkHelper linkHelper;
        if (SEARCH_WORK_ITEMS_LINK.equals(fieldsRequest.getKey())) {
            Map<String, String> parameters = fieldsRequest.getParameters();
            String baseUrl = this.searchWorkItemsProcessor.getAzureHostUrl(parameters);
            if (baseUrl != null && baseUrl.startsWith("http") && StringUtils.isNotBlank((CharSequence)this.searchWorkItemsProcessor.getOrganization(parameters))) {
                String projectName = parameters.get("project");
                GeneralRequest request = new GeneralRequest(this.searchWorkItemsProcessor.getOrganization(parameters), projectName, null);
                FieldsResponse response = this.azureRestClient.getFields(baseUrl, configuration.getAuthorization().getPersonalAccessToken(), request);
                return response.getValue().stream().filter(field -> !WORK_ITEM_ID.equals(field.getReferenceName())).collect(Collectors.toMap(FieldsResponse.Field::getReferenceName, field -> field));
            }
        } else if (StringUtils.isNotBlank((CharSequence)fieldsRequest.getParameters().get("url")) && (linkHelper = LINK_HELPERS.get(fieldsRequest.getKey())).isAccepted(url = fieldsRequest.getParameters().get("url"))) {
            String baseUrl = linkHelper.getBaseUrl(url);
            String organizationID = linkHelper.getOrganizationID(url);
            String projectName = linkHelper.getProjectName(url);
            GeneralRequest request = new GeneralRequest(organizationID, projectName, null);
            FieldsResponse response = this.azureRestClient.getFields(baseUrl, configuration.getAuthorization().getPersonalAccessToken(), request);
            return response.getValue().stream().filter(field -> !WORK_ITEM_ID.equals(field.getReferenceName())).collect(Collectors.toMap(FieldsResponse.Field::getReferenceName, field -> field));
        }
        return DEFAULT_PARAMETERS;
    }

    @JsonAutoDetect
    @JsonIgnoreProperties
    public static class FieldsRequest {
        private String key;
        private String spaceKey;
        private Map<String, String> parameters = new LinkedHashMap<String, String>();

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }

        @Generated
        public Map<String, String> getParameters() {
            return this.parameters;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        @Generated
        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }
    }
}

