/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.QueryLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.QueryCountResponse;
import com.moveworkforward.confluence.azure.model.QueryRequest;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.rest.WorkItemFieldsController;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryLinkProcessor
extends AbstractAzureLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryLinkProcessor.class);

    @Autowired
    public QueryLinkProcessor(CacheableAzureRestClient azureRestClient, AzureDevOpsSettingManager configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new QueryLinkHelper());
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        boolean showOnlyCount = Boolean.parseBoolean(parameters.get("showOnlyCount"));
        boolean hideHeader = Boolean.parseBoolean(parameters.get("hideHeader"));
        int limit = AzureMacroUtils.getIntegerValue(parameters, "itemsCount", -1);
        int recordsPerPage = AzureMacroUtils.getIntegerValue(parameters, "recordsPerPage", 10);
        String azureBaseUrl = ((AzureLinkHelper)this.linkHelper).getBaseUrl(url);
        String organizationID = ((AzureLinkHelper)this.linkHelper).getOrganizationID(url);
        String projectName = ((AzureLinkHelper)this.linkHelper).getProjectName(url);
        String queryId = ((AzureLinkHelper)this.linkHelper).getId(url);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("showOnlyCount", showOnlyCount);
        model.put("hideHeader", hideHeader);
        model.put("url", url);
        model.put("limit", limit);
        model.put("recordsPerPage", recordsPerPage);
        model.put("baseUrl", this.getBaseUrl());
        model.put("macro", "query");
        model.put("spaceKey", parameters.get("spaceKey"));
        model.put("macroName", this.i18nResolver.getText("azure-devops-confluence-integration.azure-devops-query-link.label"));
        model.put("uuid", UUID.randomUUID().toString());
        model.put("paginationUrl", this.getBaseUrl() + "/rest/azure-devops/1.0/macro/query");
        if (showOnlyCount) {
            QueryRequest request = new QueryRequest(organizationID, projectName, queryId, limit > 0 ? Integer.valueOf(limit) : null);
            QueryCountResponse response = null;
            AzureConfiguration configuration = null;
            for (AzureConfiguration currentConfiguration : configurationsHolder.getConfigurations()) {
                log.debug("Get query items using: {}", (Object)currentConfiguration);
                try {
                    response = this.azureRestClient.getQueryWorkItemsCount(azureBaseUrl, currentConfiguration.getAuthorization().getPersonalAccessToken(), request);
                    if (response == null) continue;
                    configuration = currentConfiguration;
                    break;
                }
                catch (Exception e) {
                    log.error("Can not get query work items using configurations: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
                }
            }
            log.debug("URL: {}, response: {}", (Object)url, response);
            if (response == null || configuration == null) {
                log.debug("if we don't get a response it means request was failed but PAT is set");
                return this.renderNoToken(url);
            }
            model.put("itemsCount", response.getCount());
            model.put("workItems", Collections.emptyList());
            model.put("fieldsToDisplay", Collections.emptyList());
            model.put("allFields", Collections.emptyList());
            model.put("name", response.getName());
        } else {
            Set<String> fieldsToDisplay = AzureMacroUtils.getFieldsToDisplay(parameters);
            Map<String, FieldsResponse.Field> allFields = null;
            for (AzureConfiguration currentConfiguration : configurationsHolder.getConfigurations()) {
                log.debug("Get query items using {} configuration", (Object)currentConfiguration.getLevel());
                try {
                    String token = currentConfiguration.getAuthorization().getPersonalAccessToken();
                    allFields = AzureMacroUtils.getAllFields(this.azureRestClient, azureBaseUrl, token, organizationID, projectName, null);
                    if (allFields == null) continue;
                    break;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            log.debug("URL: {}, response: {}", (Object)url, allFields);
            model.put("fieldsToDisplay", fieldsToDisplay);
            model.put("allFields", allFields == null ? WorkItemFieldsController.DEFAULT_PARAMETERS : allFields);
        }
        return this.render(model, "templates/mwf-ado-paginated-work-items.vm");
    }
}

