/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.link;

import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import java.util.Arrays;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class ReleasesLinkHelper
extends AbstractLinkHelper {
    public static final String RELEASES = "_release?";
    public static final String RELEASES_BASE_URL = "https://vsrm.dev.azure.com";

    @Override
    public String getKeyPath() {
        return RELEASES;
    }

    @Override
    public String getBaseUrl(String url) {
        String baseUrl = super.getBaseUrl(url);
        return "https://dev.azure.com".equals(baseUrl) ? RELEASES_BASE_URL : baseUrl;
    }

    @Override
    public String getId(String url) {
        List queryParams = new URIBuilder(url).getQueryParams();
        String id = queryParams.stream().filter(p -> "definitionId".equals(p.getName())).findFirst().map(NameValuePair::getValue).orElse(null);
        return id;
    }

    @Override
    public int getKeyPathIndex(List<String> parts) {
        for (int i = 0; i < parts.size(); ++i) {
            if (!parts.get(i).startsWith(this.getKeyPath())) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected boolean isUrlAccepted(List<String> parts, int expectedIndex) {
        int index = this.getKeyPathIndex(parts);
        return Arrays.asList("http:", "https:").contains(parts.get(0)) && index >= expectedIndex && parts.size() > index;
    }
}

