/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.component;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.moveworkforward.component.AbstractUserSurveyManager;
import com.moveworkforward.confluence.azure.validator.AzureRecordValidator;
import com.moveworkforward.v2.ao.impl.UserSurveyRepository;
import com.moveworkforward.v2.validation.RecordValidator;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserSurveyManager
extends AbstractUserSurveyManager {
    private static final Logger log = LoggerFactory.getLogger(UserSurveyManager.class);
    public static final String SURVEY_ID = "ZQeG8ZUT";
    private static final String PLUGIN_SETTINGS_KEY = "azure.plugin.settings";
    private static final String CLIENT_KEY = "azure.client.key";
    private final UserAccessor userAccessor;

    @Autowired
    public UserSurveyManager(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginAccessor pluginAccessor, UserSurveyRepository userSurveyRepository, AzureRecordValidator recordValidator, @ComponentImport UserAccessor userAccessor) {
        super(applicationProperties, pluginLicenseManager, pluginSettingsFactory, pluginAccessor, userSurveyRepository, (RecordValidator)recordValidator);
        this.userAccessor = userAccessor;
    }

    protected Optional<String> getUserRole(com.moveworkforward.model.User user) {
        return Optional.ofNullable(user.getUser()).map(o -> this.userAccessor.getGroupNames((User)((ConfluenceUser)user.getUser()))).orElse(Collections.emptyList()).stream().findFirst();
    }

    protected Optional<String> getUserEmail(com.moveworkforward.model.User user) {
        return Optional.ofNullable(user.getUser()).map(o -> ((ConfluenceUser)o).getEmail());
    }

    protected String getTenantKey() {
        return CLIENT_KEY;
    }

    protected String getPluginSettingsKey() {
        return PLUGIN_SETTINGS_KEY;
    }

    protected String getPluginKey() {
        return "azure-devops-confluence-integration";
    }

    public static enum SurveyLocation implements AbstractUserSurveyManager.Location
    {
        GLOBAL("global.config"),
        SPACE("space.config"),
        PERSONAL("personal.config"),
        CONTENT("content.config");

        private final String key;

        private SurveyLocation(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

