/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.validator;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.confluence.azure.component.ValidationConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.validation.ValidationGroups;
import com.moveworkforward.v2.validation.ValidationHelper;
import jakarta.validation.ConstraintViolationException;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AzureValidationHelper
implements ValidationHelper<AzureConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(AzureValidationHelper.class);
    protected final PermissionManager permissionManager;
    protected final SpaceManager spaceManager;

    @Autowired
    public AzureValidationHelper(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    public void checkWritePermissions(AzureConfiguration target) {
        Set violations = ValidationConfiguration.getValidator().validate((Object)target, new Class[]{ValidationGroups.Write.class});
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public void checkReadPermissions(AzureConfiguration target) {
        Set violations = ValidationConfiguration.getValidator().validate((Object)target, new Class[]{ValidationGroups.Read.class});
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public void checkDeletePermissions(AzureConfiguration target) {
        this.checkWritePermissions(target);
    }

    public com.moveworkforward.model.User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return Optional.ofNullable(confluenceUser).map(u -> new com.moveworkforward.model.User(u, u.getKey().getStringValue(), u.getFullName())).orElse(new com.moveworkforward.model.User());
    }

    public boolean hasReadPermissions(AzureConfiguration configuration, com.moveworkforward.model.User user) {
        return ValidationConfiguration.getValidator().validate((Object)configuration, new Class[]{ValidationGroups.Read.class}).isEmpty();
    }

    public void validate(AzureConfiguration target) {
        LinkedHashSet violations = new LinkedHashSet(ValidationConfiguration.getValidator().validate((Object)target, new Class[0]));
        violations.addAll(ValidationConfiguration.getValidator().validate((Object)target, new Class[]{ValidationGroups.Write.class}));
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    public boolean isGlobalAdmin(com.moveworkforward.model.User user) {
        return this.permissionManager.isConfluenceAdministrator((User)user.getUser());
    }

    public boolean hasTagPermission(String tag, String level) {
        com.moveworkforward.model.User user = this.getCurrentUser();
        if (this.isGlobalAdmin(user)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            return false;
        }
        if (AzureConfiguration.Level.SPACE.toString().equals(level)) {
            Space space = this.spaceManager.getSpace(tag);
            if (space != null) {
                return this.permissionManager.hasPermission((User)user.getUser(), Permission.ADMINISTER, (Object)space);
            }
        } else if (AzureConfiguration.Level.PERSONAL.toString().equals(level)) {
            return user.getUserKey().equals(tag);
        }
        return false;
    }
}

