function paginatedWorkItems(paginationUrl, macroId, parameters) {
    var container = $("#content_" + macroId);

    var currentPage = 0;

    loadWorkItems(currentPage, paginationUrl, parameters);

    function loadWorkItems(page, paginationUrl, parameters) {
        var loader = container.find("div.macro-loader");
        loader.show();

        var request = parameters;
        request["page"] = page;
        AJS.$.ajax({
            url: paginationUrl,
            type: "POST",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(request),
            dataType: "json",
            async: true,
            error: function(xhr) {
                try {
                    console.log(xhr.statusText + (": " + xhr.responseText));
                    $("#error_" + macroId).show();
                    container.hide();
                } catch(error) {
                    console.error(error);
                } finally {
                    loader.hide();
                }
            },
            success: function(response) {
                try{
                    container.find("tbody").html(response["html"]);
                    makePagination(response["total"], response["page"], paginationUrl, parameters)
                    $("#preloader_" + macroId).hide();
                    container.show();
                    container.css('display', 'inline-block');
                } catch(error) {
                    console.error(error);
                } finally {
                    loader.hide();
                }

            }
        });
    }

    function makePagination(total, page, paginationUrl, parameters) {
        var recordsPerPage = parameters["recordsPerPage"];
        if (total <= recordsPerPage) {
            return;
        }

        var pagination = container.find("div.macro-pagination");
        if (pagination.is(":visible")) {
            return;
        }

        var paginationSource = Array.from({
            length: (total / recordsPerPage) + (total % recordsPerPage > 0 ? 1 : 0)
        }, (v, i) => i);

        if (pagination.length > 0) {
            pagination.pagination({
                pageSize: 1,
                pageNumber: page + 1,
                dataSource: paginationSource,
                callback: function(data, pagination) {
                    if (currentPage != data[0]) {
                        currentPage = data[0];
                        loadWorkItems(currentPage, paginationUrl, parameters);
                    }
                }
            });
            pagination.show();
            pagination.css('display', 'flex');
        }
    }
}