/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.SearchConfigurationParameters;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.moveworkforward.confluence.common.link.LinkHelper;
import com.moveworkforward.confluence.common.processor.AbstractLinkProcessor;
import com.moveworkforward.confluence.common.processor.Processor;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureLinkProcessor
extends AbstractLinkProcessor<AzureLinkHelper, AzureConfigurationsHolder, SearchConfigurationParameters>
implements Processor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAzureLinkProcessor.class);
    protected final AzureRestClient azureRestClient;

    protected AbstractAzureLinkProcessor(AzureRestClient azureRestClient, AzureDevOpsSettingManager configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, AzureLinkHelper linkHelper) {
        super((MacroConfigurationService)configurationService, renderer, i18nResolver, webResourceUrlProvider, (LinkHelper)linkHelper);
        this.azureRestClient = azureRestClient;
    }

    public String getProject(Map<String, String> parameters) {
        return ((AzureLinkHelper)this.linkHelper).getProjectName(this.getUrl(parameters));
    }

    public String getOrganization(Map<String, String> parameters) {
        return ((AzureLinkHelper)this.linkHelper).getOrganizationID(this.getUrl(parameters));
    }

    protected String getAdminUrl() {
        return "/admin/azure-devops-for-confluence.action";
    }

    public String getAzureHostUrl(Map<String, String> parameters) {
        return ((AzureLinkHelper)this.linkHelper).getBaseUrl(this.getUrl(parameters));
    }

    public String getAzureOriginalHostUrl(Map<String, String> parameters) {
        return ((AzureLinkHelper)this.linkHelper).getOriginalBaseUrl(this.getUrl(parameters));
    }

    protected boolean isTokenNotDefined(AzureConfigurationsHolder configurationsHolder) {
        return configurationsHolder == null || configurationsHolder.isEmpty();
    }

    protected SearchConfigurationParameters getSearchConfigurationParameters(Map<String, String> parameters, ConversionContext conversionContext) {
        return new SearchConfigurationParameters(this.getAzureOriginalHostUrl(parameters), this.getOrganization(parameters), conversionContext.getSpaceKey());
    }
}

