/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.confluence.azure.ao.converters.AzureConfigurationConverter;
import com.moveworkforward.confluence.azure.validation.LevelPermissionConstraint;
import com.moveworkforward.confluence.azure.validation.SpacePermissionConstraint;
import com.moveworkforward.confluence.azure.validation.ValidationGroups;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.ConfigurationLevel;
import com.moveworkforward.v2.ao.Persistence;
import com.moveworkforward.v2.model.IdModel;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;

@Persistence(entityType="AZURE_CONFIGURATION_2", converter=AzureConfigurationConverter.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@LevelPermissionConstraint(groups={ValidationGroups.Write.class, ValidationGroups.Read.class})
@JsonAutoDetect
public class AzureConfiguration
extends AbstractPluginEntity
implements Cloneable,
IdModel {
    public static final String TYPE = "AZURE_CONFIGURATION_2";
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    public static final String DEFAULT_BASE_URL = "https://dev.azure.com";
    private String key;
    @NotBlank
    private String name;
    @NotNull
    private Authorization authorization = new Authorization();
    @NotBlank
    @URL
    private String baseUrl;
    private String organization;
    private String createdBy;
    @NotNull
    private Level level = Level.GLOBAL;
    @SpacePermissionConstraint
    private String spaceKey;
    private String userKey;
    private List<@NotBlank String> includedSpaceKeys = new ArrayList<String>();
    private List<@NotBlank String> excludedSpaceKeys = new ArrayList<String>();

    public boolean isEnabledAndConfigured() {
        return this.isEnabled() && this.getAuthorization() != null && this.getAuthorization().isConfigured();
    }

    public AzureConfiguration clone() {
        try {
            AzureConfiguration clone = (AzureConfiguration)super.clone();
            clone.setAuthorization(this.getAuthorization().clone());
            clone.setIncludedSpaceKeys((List<String>)(this.getIncludedSpaceKeys() == null ? null : new ArrayList<String>(this.getIncludedSpaceKeys())));
            clone.setExcludedSpaceKeys((List<String>)(this.getExcludedSpaceKeys() == null ? null : new ArrayList<String>(this.getExcludedSpaceKeys())));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public boolean isSpaceAllowed(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return true;
        }
        if (Level.SPACE.equals((Object)this.level)) {
            return this.spaceKey.equals(spaceKey);
        }
        if (CollectionUtils.isNotEmpty(this.includedSpaceKeys) && !this.includedSpaceKeys.contains(spaceKey)) {
            return false;
        }
        return !CollectionUtils.isNotEmpty(this.excludedSpaceKeys) || !this.includedSpaceKeys.contains(spaceKey);
    }

    @Generated
    public AzureConfiguration() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Authorization getAuthorization() {
        return this.authorization;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getOrganization() {
        return this.organization;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Generated
    public String getUserKey() {
        return this.userKey;
    }

    @Generated
    public List<@NotBlank String> getIncludedSpaceKeys() {
        return this.includedSpaceKeys;
    }

    @Generated
    public List<@NotBlank String> getExcludedSpaceKeys() {
        return this.excludedSpaceKeys;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setLevel(Level level) {
        this.level = level;
    }

    @Generated
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    @Generated
    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    @Generated
    public void setIncludedSpaceKeys(List<@NotBlank String> includedSpaceKeys) {
        this.includedSpaceKeys = includedSpaceKeys;
    }

    @Generated
    public void setExcludedSpaceKeys(List<@NotBlank String> excludedSpaceKeys) {
        this.excludedSpaceKeys = excludedSpaceKeys;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureConfiguration)) {
            return false;
        }
        AzureConfiguration other = (AzureConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AzureConfiguration;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public String toString() {
        return "AzureConfiguration(super=" + super.toString() + ", key=" + this.getKey() + ", name=" + this.getName() + ", authorization=" + this.getAuthorization() + ", baseUrl=" + this.getBaseUrl() + ", organization=" + this.getOrganization() + ", createdBy=" + this.getCreatedBy() + ", level=" + this.getLevel() + ", spaceKey=" + this.getSpaceKey() + ", userKey=" + this.getUserKey() + ", includedSpaceKeys=" + this.getIncludedSpaceKeys() + ", excludedSpaceKeys=" + this.getExcludedSpaceKeys() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonAutoDetect
    public static class Authorization
    implements Serializable,
    Cloneable {
        @NotBlank
        private String personalAccessToken;
        private AuthorizationType type = AuthorizationType.PAT;

        public Authorization clone() {
            try {
                return (Authorization)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        public boolean isConfigured() {
            return StringUtils.isNotBlank((CharSequence)this.personalAccessToken);
        }

        @Generated
        public Authorization() {
        }

        @Generated
        public String getPersonalAccessToken() {
            return this.personalAccessToken;
        }

        @Generated
        public AuthorizationType getType() {
            return this.type;
        }

        @Generated
        public void setPersonalAccessToken(String personalAccessToken) {
            this.personalAccessToken = personalAccessToken;
        }

        @Generated
        public void setType(AuthorizationType type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Authorization)) {
                return false;
            }
            Authorization other = (Authorization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$personalAccessToken = this.getPersonalAccessToken();
            String other$personalAccessToken = other.getPersonalAccessToken();
            if (this$personalAccessToken == null ? other$personalAccessToken != null : !this$personalAccessToken.equals(other$personalAccessToken)) {
                return false;
            }
            AuthorizationType this$type = this.getType();
            AuthorizationType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Authorization;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $personalAccessToken = this.getPersonalAccessToken();
            result = result * 59 + ($personalAccessToken == null ? 43 : $personalAccessToken.hashCode());
            AuthorizationType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @Generated
        public Authorization(String personalAccessToken, AuthorizationType type) {
            this.personalAccessToken = personalAccessToken;
            this.type = type;
        }

        @Generated
        public String toString() {
            return "AzureConfiguration.Authorization()";
        }
    }

    public static enum Level implements ConfigurationLevel
    {
        PERSONAL,
        GLOBAL,
        SPACE;

    }

    public static enum AuthorizationType {
        PAT;

    }
}

