/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.model;

import com.moveworkforward.confluence.azure.ao.converters.AzureConfigurationConverter;
import com.moveworkforward.confluence.azure.validation.LevelPermissionConstraint;
import com.moveworkforward.confluence.azure.validation.SpacePermissionConstraint;
import com.moveworkforward.confluence.azure.validation.ValidationGroups;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.ConfigurationLevel;
import com.moveworkforward.v2.ao.Persistence;
import com.moveworkforward.v2.model.IdModel;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.validator.constraints.URL;

@Persistence(entityType="AZURE_CONFIGURATION_2", converter=AzureConfigurationConverter.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@LevelPermissionConstraint(groups={ValidationGroups.Write.class, ValidationGroups.Read.class})
@JsonAutoDetect
public class AzureConfiguration
extends AbstractPluginEntity
implements Cloneable,
IdModel {
    public static final String TYPE = "AZURE_CONFIGURATION_2";
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    public static final String DEFAULT_BASE_URL = "https://dev.azure.com";
    private String key;
    @NotBlank
    private String name;
    @NotNull
    private Authorization authorization = new Authorization();
    @NotBlank
    @URL
    private String baseUrl;
    private String organization;
    private String createdBy;
    @NotNull
    private Level level = Level.GLOBAL;
    @SpacePermissionConstraint
    private String spaceKey;
    private String userKey;
    private List<@NotBlank String> includedSpaceKeys = new ArrayList<String>();
    private List<@NotBlank String> excludedSpaceKeys = new ArrayList<String>();

    public boolean isEnabledAndConfigured() {
        return this.isEnabled() && this.getAuthorization() != null && this.getAuthorization().isConfigured();
    }

    public AzureConfiguration clone() {
        try {
            AzureConfiguration clone = (AzureConfiguration)super.clone();
            clone.setAuthorization(this.getAuthorization().clone());
            clone.setIncludedSpaceKeys((List<String>)(this.getIncludedSpaceKeys() == null ? null : new ArrayList<String>(this.getIncludedSpaceKeys())));
            clone.setExcludedSpaceKeys((List<String>)(this.getExcludedSpaceKeys() == null ? null : new ArrayList<String>(this.getExcludedSpaceKeys())));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public boolean isSpaceAllowed(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return true;
        }
        if (Level.SPACE.equals((Object)this.level)) {
            return this.spaceKey.equals(spaceKey);
        }
        if (CollectionUtils.isNotEmpty(this.includedSpaceKeys) && !this.includedSpaceKeys.contains(spaceKey)) {
            return false;
        }
        return !CollectionUtils.isNotEmpty(this.excludedSpaceKeys) || !this.includedSpaceKeys.contains(spaceKey);
    }

    public String getName() {
        return this.name;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public List<@NotBlank String> getIncludedSpaceKeys() {
        return this.includedSpaceKeys;
    }

    public List<@NotBlank String> getExcludedSpaceKeys() {
        return this.excludedSpaceKeys;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public void setIncludedSpaceKeys(List<@NotBlank String> includedSpaceKeys) {
        this.includedSpaceKeys = includedSpaceKeys;
    }

    public void setExcludedSpaceKeys(List<@NotBlank String> excludedSpaceKeys) {
        this.excludedSpaceKeys = excludedSpaceKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureConfiguration)) {
            return false;
        }
        AzureConfiguration other = (AzureConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AzureConfiguration;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "AzureConfiguration(super=" + super.toString() + ", key=" + this.getKey() + ", name=" + this.getName() + ", authorization=" + this.getAuthorization() + ", baseUrl=" + this.getBaseUrl() + ", organization=" + this.getOrganization() + ", createdBy=" + this.getCreatedBy() + ", level=" + (Object)((Object)this.getLevel()) + ", spaceKey=" + this.getSpaceKey() + ", userKey=" + this.getUserKey() + ", includedSpaceKeys=" + this.getIncludedSpaceKeys() + ", excludedSpaceKeys=" + this.getExcludedSpaceKeys() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonAutoDetect
    public static class Authorization
    implements Serializable,
    Cloneable {
        @NotBlank
        private String personalAccessToken;
        private AuthorizationType type = AuthorizationType.PAT;

        public Authorization clone() {
            try {
                return (Authorization)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        public boolean isConfigured() {
            return StringUtils.isNotBlank((CharSequence)this.personalAccessToken);
        }

        public Authorization() {
        }

        public String getPersonalAccessToken() {
            return this.personalAccessToken;
        }

        public AuthorizationType getType() {
            return this.type;
        }

        public void setPersonalAccessToken(String personalAccessToken) {
            this.personalAccessToken = personalAccessToken;
        }

        public void setType(AuthorizationType type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Authorization)) {
                return false;
            }
            Authorization other = (Authorization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$personalAccessToken = this.getPersonalAccessToken();
            String other$personalAccessToken = other.getPersonalAccessToken();
            if (this$personalAccessToken == null ? other$personalAccessToken != null : !this$personalAccessToken.equals(other$personalAccessToken)) {
                return false;
            }
            AuthorizationType this$type = this.getType();
            AuthorizationType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Authorization;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $personalAccessToken = this.getPersonalAccessToken();
            result = result * 59 + ($personalAccessToken == null ? 43 : $personalAccessToken.hashCode());
            AuthorizationType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public Authorization(String personalAccessToken, AuthorizationType type) {
            this.personalAccessToken = personalAccessToken;
            this.type = type;
        }

        public String toString() {
            return "AzureConfiguration.Authorization()";
        }
    }

    public static enum AuthorizationType {
        PAT;

    }

    public static enum Level implements ConfigurationLevel
    {
        PERSONAL,
        GLOBAL,
        SPACE;

    }
}

