/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.mapper;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.moveworkforward.confluence.azure.rest.model.UserHolder;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public class UserMapper {
    @ComponentImport
    @Autowired
    private UserAccessor userAccessor;
    @ComponentImport
    @Autowired
    private UserManager userManager;
    @ComponentImport
    @Autowired
    private WebResourceUrlProvider webResourceUrlProvider;

    public String userToString(UserHolder user) {
        if (Objects.isNull(user)) {
            return null;
        }
        return user.getUserKey();
    }

    public UserHolder stringToUser(String userKey) {
        if (StringUtils.isBlank((CharSequence)userKey)) {
            return null;
        }
        UserHolder result = new UserHolder();
        result.setUserKey(userKey);
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(userKey));
        if (confluenceUser != null) {
            result.setUserName(confluenceUser.getName());
            result.setUserFullName(confluenceUser.getFullName());
            UserProfile userProfile = this.userManager.getUserProfile(confluenceUser.getName());
            if (userProfile != null && userProfile.getProfilePictureUri() != null) {
                URI pictureURI = userProfile.getProfilePictureUri();
                if (pictureURI.isAbsolute()) {
                    result.setLogoUrl(pictureURI.toString());
                } else {
                    result.setLogoUrl(this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE) + pictureURI);
                }
            }
        }
        return result;
    }
}

