/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.validation;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.confluence.azure.validation.SpacePermissionConstraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SpacePermissionValidator
implements ConstraintValidator<SpacePermissionConstraint, String> {
    @ComponentImport
    @Autowired
    private PermissionManager permissionManager;
    @ComponentImport
    @Autowired
    private SpaceManager spaceManager;

    public boolean isValid(String spaceKey, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return true;
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return SpacePermissionValidator.isGlobalAdmin(this.permissionManager, confluenceUser);
        }
        if (!this.permissionManager.hasPermission((User)confluenceUser, Permission.ADMINISTER, (Object)space)) {
            return SpacePermissionValidator.isGlobalAdmin(this.permissionManager, confluenceUser);
        }
        return true;
    }

    public static boolean isGlobalAdmin(PermissionManager permissionManager, ConfluenceUser confluenceUser) {
        return permissionManager.isConfluenceAdministrator((User)confluenceUser);
    }
}

