/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.service;

import com.moveworkforward.confluence.azure.ao.AzureRepository;
import com.moveworkforward.confluence.azure.ao.converters.AzureConfigurationConverter;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.PaginationRequest;
import com.moveworkforward.confluence.azure.model.PaginationResponse;
import com.moveworkforward.confluence.azure.validator.AzureValidationHelper;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.v2.ao.PluginRepository;
import com.moveworkforward.v2.model.IdModel;
import com.moveworkforward.v2.service.impl.AbstractConfigurationService;
import com.moveworkforward.v2.validation.ValidationHelper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.springframework.stereotype.Component;

@Component
public class AzureConfigurationService
extends AbstractConfigurationService<AzureConfiguration> {
    public AzureConfigurationService(AzureRepository repository, AzureValidationHelper validationHelper) {
        super((PluginRepository)repository, (ValidationHelper)validationHelper);
    }

    protected void validate(AzureConfiguration newConfiguration) {
        newConfiguration.setLastModified(new Date());
        if (StringUtils.isBlank((CharSequence)newConfiguration.getCreatedBy())) {
            newConfiguration.setCreatedBy(this.validationHelper.getCurrentUser().getUserKey());
        }
        if (StringUtils.isBlank((CharSequence)newConfiguration.getUserKey()) && AzureConfiguration.Level.PERSONAL.equals((Object)newConfiguration.getLevel())) {
            newConfiguration.setUserKey(this.validationHelper.getCurrentUser().getUserKey());
        }
        super.validate((IdModel)newConfiguration);
        if (AzureConfiguration.Level.SPACE.equals((Object)newConfiguration.getLevel()) && CollectionUtils.isNotEmpty(newConfiguration.getExcludedSpaceKeys())) {
            throw new DetailedException("Excluded space keys must be empty", new String[]{"excludedSpaceKeys"});
        }
        if (StringUtils.isBlank((CharSequence)newConfiguration.getBaseUrl()) || !new UrlValidator(8L).isValid(newConfiguration.getBaseUrl())) {
            throw new DetailedException("Invalid URL", new String[]{"baseUrl"});
        }
        List existingConfigurations = this.pluginRepository.getByTag(AzureConfigurationConverter.getTag(newConfiguration), AzureConfiguration.class);
        for (AzureConfiguration existingConfiguration : existingConfigurations) {
            if (Objects.equals(existingConfiguration.getId(), newConfiguration.getId()) || !Objects.equals(existingConfiguration.getBaseUrl(), newConfiguration.getBaseUrl()) || !Objects.equals(existingConfiguration.getOrganization(), newConfiguration.getOrganization())) continue;
            throw new DetailedException("Configuration for the same parameters already exists", new String[]{"baseUrl", "organization"});
        }
        if (CollectionUtils.containsAny(newConfiguration.getIncludedSpaceKeys(), newConfiguration.getExcludedSpaceKeys())) {
            throw new DetailedException("Can not include/exclude the same spaces", new String[]{"includedSpaceKeys", "excludedSpaceKeys"});
        }
        if ("XXXXXXXXX".equals(newConfiguration.getAuthorization().getPersonalAccessToken()) && newConfiguration.getId() != null) {
            AzureConfiguration existingConfiguration = (AzureConfiguration)this.pluginRepository.get(newConfiguration.getId().intValue(), AzureConfiguration.class);
            newConfiguration.getAuthorization().setPersonalAccessToken(existingConfiguration.getAuthorization().getPersonalAccessToken());
        }
    }

    public PaginationResponse getPersonalConfigurations(String userKey, int start, int limit) {
        if (StringUtils.isBlank((CharSequence)userKey)) {
            userKey = this.validationHelper.getCurrentUser().getUserKey();
        }
        if (!this.validationHelper.hasTagPermission(userKey, AzureConfiguration.Level.PERSONAL.toString())) {
            return new PaginationResponse();
        }
        return this.getByTag(userKey, start, limit);
    }

    public PaginationResponse getConfigurations(String spaceKey, int start, int limit) {
        PaginationResponse response = new PaginationResponse();
        if (!this.validationHelper.hasTagPermission(spaceKey, AzureConfiguration.Level.SPACE.toString())) {
            return response;
        }
        return this.getByTag(spaceKey, start, limit);
    }

    private PaginationResponse getByTag(String tag, int start, int limit) {
        int totalSize;
        List results;
        limit = limit <= 0 ? 20 : limit;
        PaginationRequest pageRequest = new PaginationRequest(start, limit);
        if (StringUtils.isBlank((CharSequence)tag)) {
            results = this.pluginRepository.getAll(limit, start, AzureConfiguration.class);
            totalSize = this.pluginRepository.count(AzureConfiguration.class);
        } else {
            results = this.pluginRepository.getByTag(tag, limit, start, AzureConfiguration.class);
            totalSize = this.pluginRepository.count(tag, AzureConfiguration.class);
        }
        return new PaginationResponse(pageRequest, results, limit * start + results.size() < totalSize, totalSize);
    }
}

