/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.DelegateWorkItemLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDateTimeFormat;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.rest.WorkItemFieldsController;
import com.moveworkforward.confluence.azure.service.AzureDevOpsSettingManager;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import com.moveworkforward.confluence.common.processor.Processor;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkItemLinkProcessor
extends AbstractAzureLinkProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(WorkItemLinkProcessor.class);
    private final AzureDevOpsSettingManager settingManager;

    @Autowired
    public WorkItemLinkProcessor(CacheableAzureRestClient azureRestClient, AzureDevOpsSettingManager configurationService, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, AzureDevOpsSettingManager settingManager) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new DelegateWorkItemLinkHelper());
        this.settingManager = settingManager;
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        boolean hideHeader = Boolean.parseBoolean(parameters.get("hideHeader"));
        String azureBaseUrl = this.getAzureHostUrl(parameters);
        String organizationID = this.getOrganization(parameters);
        String projectName = this.getProject(parameters);
        String workItemId = ((AzureLinkHelper)this.linkHelper).getId(url);
        GeneralRequest request = new GeneralRequest(organizationID, projectName, workItemId);
        AzureConfiguration configuration = null;
        WorkItemResponse response = null;
        for (AzureConfiguration currentConfiguration : configurationsHolder.getConfigurations()) {
            log.debug("Get work items using: {}", (Object)currentConfiguration);
            try {
                response = this.azureRestClient.getWorkItem(azureBaseUrl, currentConfiguration.getAuthorization().getPersonalAccessToken(), request);
                if (response == null) continue;
                configuration = currentConfiguration;
                break;
            }
            catch (Exception e) {
                log.warn("Can not work items using configuration: {}, message: {}", new Object[]{configuration, e.getMessage(), e});
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, response);
        if (response == null || configuration == null) {
            return this.renderNoToken(url);
        }
        Set<String> fieldsToDisplay = AzureMacroUtils.getFieldsToDisplay(parameters);
        String token = configuration.getAuthorization().getPersonalAccessToken();
        Map<String, FieldsResponse.Field> allFields = AzureMacroUtils.getAllFields(this.azureRestClient, azureBaseUrl, token, organizationID, projectName, WorkItemFieldsController.DEFAULT_PARAMETERS);
        AzureDateTimeFormat dateTimeFormat = Optional.ofNullable(this.settingManager.getGlobalSettings().getDateTimeFormat()).orElse(AzureDateTimeFormat.NONE);
        Map<String, Object> model = AzureMacroUtils.workItemToModel(response);
        model.put("fieldsToDisplay", fieldsToDisplay);
        model.put("allFields", allFields);
        model.put("hideHeader", hideHeader);
        model.put("workItems", Arrays.asList(model));
        model.put("spaceKey", parameters.get("spaceKey"));
        model.put("dateTimeFormat", (Object)dateTimeFormat);
        return this.render(model, "templates/mwf-ado-work-item.vm");
    }
}

