/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.model.old;

import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.model.AbstractPluginEntity;
import com.moveworkforward.model.Source;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@EntityType(value="AZURE_CONFIGURATION")
@JsonIgnoreProperties(ignoreUnknown=true, value={"key", "tag"})
@JsonAutoDetect
public class AzureDevOpsConfiguration
extends AbstractPluginEntity
implements Cloneable {
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    public static final String DEFAULT_BASE_URL = "https://dev.azure.com";
    private String addonId = "azure-devops-confluence-integration";
    private Configuration configuration = new Configuration();
    private String key;
    private AzureConfiguration.Level level = AzureConfiguration.Level.GLOBAL;
    private String spaceKey;
    private String userKey;
    protected List<SourceEntity> sources = new ArrayList<SourceEntity>();

    public String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public String getTag() {
        switch (this.level) {
            case GLOBAL: {
                return ALL_SPACES;
            }
            case PERSONAL: {
                return this.userKey;
            }
            case SPACE: {
                return this.spaceKey;
            }
        }
        throw new RuntimeException("Unknown level: " + (Object)((Object)this.level));
    }

    public AzureDevOpsConfiguration clone() {
        try {
            AzureDevOpsConfiguration clone = (AzureDevOpsConfiguration)super.clone();
            clone.setConfiguration(this.getConfiguration().clone());
            clone.setSources((List<SourceEntity>)(this.getSources() == null ? null : new ArrayList<SourceEntity>(this.getSources())));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getAddonId() {
        return this.addonId;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public AzureConfiguration.Level getLevel() {
        return this.level;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public List<SourceEntity> getSources() {
        return this.sources;
    }

    public void setAddonId(String addonId) {
        this.addonId = addonId;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setLevel(AzureConfiguration.Level level) {
        this.level = level;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public void setSources(List<SourceEntity> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureDevOpsConfiguration)) {
            return false;
        }
        AzureDevOpsConfiguration other = (AzureDevOpsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AzureDevOpsConfiguration;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "AzureDevOpsConfiguration(super=" + super.toString() + ", addonId=" + this.getAddonId() + ", key=" + this.getKey() + ", level=" + (Object)((Object)this.getLevel()) + ", spaceKey=" + this.getSpaceKey() + ", userKey=" + this.getUserKey() + ", sources=" + this.getSources() + ")";
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SourceEntity
    implements Source {
        private String spaceKey;

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceEntity)) {
                return false;
            }
            SourceEntity other = (SourceEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$spaceKey = this.getSpaceKey();
            String other$spaceKey = other.getSpaceKey();
            return !(this$spaceKey == null ? other$spaceKey != null : !this$spaceKey.equals(other$spaceKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourceEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $spaceKey = this.getSpaceKey();
            result = result * 59 + ($spaceKey == null ? 43 : $spaceKey.hashCode());
            return result;
        }

        public String toString() {
            return "AzureDevOpsConfiguration.SourceEntity(spaceKey=" + this.getSpaceKey() + ")";
        }

        public SourceEntity() {
        }

        public SourceEntity(String spaceKey) {
            this.spaceKey = spaceKey;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonAutoDetect
    public static class Configuration
    implements Serializable,
    Cloneable {
        private String personalAccessToken;
        private String baseUrl = "https://dev.azure.com";
        private boolean useBaseUrl;
        private String organization;
        private boolean useOrganization;

        public Configuration clone() {
            try {
                return (Configuration)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        public String getPersonalAccessToken() {
            return this.personalAccessToken;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public boolean isUseBaseUrl() {
            return this.useBaseUrl;
        }

        public String getOrganization() {
            return this.organization;
        }

        public boolean isUseOrganization() {
            return this.useOrganization;
        }

        public void setPersonalAccessToken(String personalAccessToken) {
            this.personalAccessToken = personalAccessToken;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setUseBaseUrl(boolean useBaseUrl) {
            this.useBaseUrl = useBaseUrl;
        }

        public void setOrganization(String organization) {
            this.organization = organization;
        }

        public void setUseOrganization(boolean useOrganization) {
            this.useOrganization = useOrganization;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUseBaseUrl() != other.isUseBaseUrl()) {
                return false;
            }
            if (this.isUseOrganization() != other.isUseOrganization()) {
                return false;
            }
            String this$personalAccessToken = this.getPersonalAccessToken();
            String other$personalAccessToken = other.getPersonalAccessToken();
            if (this$personalAccessToken == null ? other$personalAccessToken != null : !this$personalAccessToken.equals(other$personalAccessToken)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
                return false;
            }
            String this$organization = this.getOrganization();
            String other$organization = other.getOrganization();
            return !(this$organization == null ? other$organization != null : !this$organization.equals(other$organization));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseBaseUrl() ? 79 : 97);
            result = result * 59 + (this.isUseOrganization() ? 79 : 97);
            String $personalAccessToken = this.getPersonalAccessToken();
            result = result * 59 + ($personalAccessToken == null ? 43 : $personalAccessToken.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            String $organization = this.getOrganization();
            result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
            return result;
        }

        public String toString() {
            return "AzureDevOpsConfiguration.Configuration(baseUrl=" + this.getBaseUrl() + ", useBaseUrl=" + this.isUseBaseUrl() + ", organization=" + this.getOrganization() + ", useOrganization=" + this.isUseOrganization() + ")";
        }
    }
}

