/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.mapper;

import com.moveworkforward.confluence.azure.mapper.ConfigurationMapper;
import com.moveworkforward.confluence.azure.mapper.PaginationResponseMapper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.model.PaginationResponse;
import com.moveworkforward.confluence.azure.rest.model.AzureRestConfiguration;
import com.moveworkforward.confluence.azure.rest.model.PaginationRestResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaginationResponseMapperImpl
implements PaginationResponseMapper {
    @Autowired
    private ConfigurationMapper configurationMapper;

    @Override
    public PaginationRestResponse responseToRest(PaginationResponse paginationResponse) {
        if (paginationResponse == null) {
            return null;
        }
        PaginationRestResponse paginationRestResponse = new PaginationRestResponse();
        paginationRestResponse.setPageRequest(paginationResponse.getPageRequest());
        paginationRestResponse.setResults(this.azureConfigurationListToAzureRestConfigurationList(paginationResponse.getResults()));
        paginationRestResponse.setHasMore(paginationResponse.isHasMore());
        paginationRestResponse.setTotalSize(paginationResponse.getTotalSize());
        return paginationRestResponse;
    }

    protected List<AzureRestConfiguration> azureConfigurationListToAzureRestConfigurationList(List<AzureConfiguration> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AzureRestConfiguration> list1 = new ArrayList<AzureRestConfiguration>(list.size());
        for (AzureConfiguration azureConfiguration : list) {
            list1.add(this.configurationMapper.configurationCtrlToRest(azureConfiguration));
        }
        return list1;
    }
}

