/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.mapper;

import com.moveworkforward.confluence.azure.mapper.AuthorizationMapper;
import com.moveworkforward.confluence.azure.mapper.ConfigurationMapper;
import com.moveworkforward.confluence.azure.mapper.SpaceMapper;
import com.moveworkforward.confluence.azure.mapper.UserMapper;
import com.moveworkforward.confluence.azure.model.AzureConfiguration;
import com.moveworkforward.confluence.azure.rest.model.AzureRestConfiguration;
import com.moveworkforward.confluence.azure.rest.model.SpaceHolder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationMapperImpl
implements ConfigurationMapper {
    @Autowired
    private SpaceMapper spaceMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private AuthorizationMapper authorizationMapper;

    @Override
    public AzureRestConfiguration configurationCtrlToRest(AzureConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        AzureRestConfiguration azureRestConfiguration = new AzureRestConfiguration();
        azureRestConfiguration.setSpace(this.spaceMapper.stringToSpace(configuration.getSpaceKey()));
        azureRestConfiguration.setUser(this.userMapper.stringToUser(configuration.getUserKey()));
        azureRestConfiguration.setIncludedSpaces(this.stringListToSpaceHolderList(configuration.getIncludedSpaceKeys()));
        azureRestConfiguration.setExcludedSpaces(this.stringListToSpaceHolderList(configuration.getExcludedSpaceKeys()));
        if (configuration.getLastModified() != null) {
            azureRestConfiguration.setLastModified(new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(configuration.getLastModified()));
        }
        azureRestConfiguration.setId(configuration.getId());
        azureRestConfiguration.setEnabled(configuration.isEnabled());
        azureRestConfiguration.setName(configuration.getName());
        azureRestConfiguration.setAuthorization(this.authorizationMapper.authorizationCtrlToRest(configuration.getAuthorization()));
        azureRestConfiguration.setBaseUrl(configuration.getBaseUrl());
        azureRestConfiguration.setOrganization(configuration.getOrganization());
        azureRestConfiguration.setCreatedBy(this.userMapper.stringToUser(configuration.getCreatedBy()));
        azureRestConfiguration.setLevel(configuration.getLevel());
        return azureRestConfiguration;
    }

    @Override
    public AzureConfiguration configurationRestToCtrl(AzureRestConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        AzureConfiguration azureConfiguration = new AzureConfiguration();
        azureConfiguration.setSpaceKey(this.spaceMapper.spaceToString(configuration.getSpace()));
        azureConfiguration.setUserKey(this.userMapper.userToString(configuration.getUser()));
        azureConfiguration.setIncludedSpaceKeys(this.spaceHolderListToStringList(configuration.getIncludedSpaces()));
        azureConfiguration.setExcludedSpaceKeys(this.spaceHolderListToStringList(configuration.getExcludedSpaces()));
        try {
            if (configuration.getLastModified() != null) {
                azureConfiguration.setLastModified(new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse(configuration.getLastModified()));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        azureConfiguration.setId(configuration.getId());
        azureConfiguration.setEnabled(configuration.isEnabled());
        azureConfiguration.setName(configuration.getName());
        azureConfiguration.setAuthorization(this.authorizationMapper.configurationRestToCtrl(configuration.getAuthorization()));
        azureConfiguration.setBaseUrl(configuration.getBaseUrl());
        azureConfiguration.setOrganization(configuration.getOrganization());
        azureConfiguration.setCreatedBy(this.userMapper.userToString(configuration.getCreatedBy()));
        azureConfiguration.setLevel(configuration.getLevel());
        return azureConfiguration;
    }

    protected List<SpaceHolder> stringListToSpaceHolderList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SpaceHolder> list1 = new ArrayList<SpaceHolder>(list.size());
        for (String string : list) {
            list1.add(this.spaceMapper.stringToSpace(string));
        }
        return list1;
    }

    protected List<String> spaceHolderListToStringList(List<SpaceHolder> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> list1 = new ArrayList<String>(list.size());
        for (SpaceHolder spaceHolder : list) {
            list1.add(this.spaceMapper.spaceToString(spaceHolder));
        }
        return list1;
    }
}

