/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.utils;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.IconProperty;
import com.moveworkforward.confluence.azure.model.User;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.rest.WorkItemFieldsController;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureMacroUtils {
    private static final Logger log = LoggerFactory.getLogger(AzureMacroUtils.class);

    public static Set<String> getFieldsToDisplay(Map<String, String> parameters) {
        String val = parameters.get("fields");
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)val)) {
            fields.addAll(Arrays.asList(val.split("\\,")));
        }
        fields.remove("System.Id");
        if (fields.isEmpty()) {
            fields.addAll(WorkItemFieldsController.DEFAULT_PARAMETERS.keySet());
        }
        return fields;
    }

    public static String render(TemplateRenderer renderer, Map<String, Object> model, String template) {
        try {
            log.debug("Model for rendering: {}", model);
            StringWriter stringWriter = new StringWriter();
            renderer.render(template, model, (Writer)stringWriter);
            stringWriter.flush();
            stringWriter.close();
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Can't render";
        }
    }

    public static String getSearchOrganization(String organization, AzureDevOpsConfiguration configuration) {
        return configuration.getConfiguration().isUseOrganization() ? configuration.getConfiguration().getOrganization() : organization;
    }

    public static String getSearchUrl(String url, AzureDevOpsConfiguration configuration) {
        return configuration.getConfiguration().isUseBaseUrl() ? configuration.getConfiguration().getBaseUrl() : url;
    }

    public static Map<String, Object> workItemToModel(WorkItemResponse workItemResponse) {
        String workItemId = String.valueOf(workItemResponse.getId());
        String url = workItemResponse.getLinks().getHtml().getHref();
        Map<String, Object> workItemFields = workItemResponse.getFields();
        workItemFields.computeIfAbsent("System.AssignedTo", key -> User.unassignedUser());
        IconProperty iconProperty = IconProperty.fromWorkItemType((String)workItemFields.get("System.WorkItemType"));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("workItemId", workItemId);
        model.put("iconProperty", (Object)iconProperty);
        model.put("stateColour", AzureMacroUtils.getStateColour((String)workItemFields.get("System.State")));
        model.put("assignee", workItemFields.getOrDefault("System.AssignedTo", User.unassignedUser()));
        model.put("title", workItemFields.get("System.Title"));
        model.put("state", workItemFields.get("System.State"));
        model.put("url", url);
        model.put("workItemFields", workItemFields);
        return model;
    }

    public static String getStateColour(String workItemState) {
        String stateColour = "178, 178, 178";
        if (Arrays.asList("Doing", "Ready", "Active").contains(workItemState)) {
            stateColour = "0, 122, 204";
        }
        return stateColour;
    }

    public static Map<String, FieldsResponse.Field> getAllFields(AzureRestClient azureRestClient, String baseUrl, String token, String organizationID, String projectName, Map<String, FieldsResponse.Field> defaultFields) {
        try {
            GeneralRequest request = new GeneralRequest(organizationID, projectName, null);
            FieldsResponse response = azureRestClient.getFields(baseUrl, token, request);
            return response.getValue().stream().collect(Collectors.toMap(FieldsResponse.Field::getReferenceName, field -> field));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultFields;
        }
    }

    public static Integer getIntegerValue(Map<String, String> parameters, String name, Integer defaultValue) {
        Integer value = defaultValue;
        try {
            String itemsCountParam = parameters.get(name);
            if (StringUtils.isNotBlank((CharSequence)itemsCountParam)) {
                value = Integer.valueOf(itemsCountParam);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

