/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.service;

import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.AzureGlobalSettings;
import com.moveworkforward.confluence.azure.service.AzureDevOpsGlobalConfigurationService;
import com.moveworkforward.confluence.azure.service.AzureDevOpsPersonalConfigurationService;
import com.moveworkforward.confluence.azure.service.AzureGlobalSettingsService;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelegateAzureDevOpsConfigurationService
implements MacroConfigurationService<AzureConfigurationsHolder> {
    private static final Logger log = LoggerFactory.getLogger(DelegateAzureDevOpsConfigurationService.class);
    private final AzureDevOpsPersonalConfigurationService personalConfigurationService;
    private final AzureDevOpsGlobalConfigurationService globalConfigurationService;
    private final AzureGlobalSettingsService globalSettingsService;
    private final CacheableAzureRestClient azureRestClient;

    @Autowired
    public DelegateAzureDevOpsConfigurationService(AzureDevOpsPersonalConfigurationService personalConfigurationService, AzureDevOpsGlobalConfigurationService globalConfigurationService, AzureGlobalSettingsService globalSettingsService, CacheableAzureRestClient azureRestClient) {
        this.personalConfigurationService = personalConfigurationService;
        this.globalConfigurationService = globalConfigurationService;
        this.globalSettingsService = globalSettingsService;
        this.azureRestClient = azureRestClient;
    }

    public AzureConfigurationsHolder get() {
        AzureGlobalSettings globalSettings = this.globalSettingsService.get(AbstractConfigurationService.DO_NOT_CHECK_PERMISSIONS);
        AzureConfigurationsHolder configurationsHolder = new AzureConfigurationsHolder();
        this.azureRestClient.updateCacheConfiguration(globalSettings.getCacheMaxEntries(), globalSettings.getCacheExpirationInSeconds());
        log.debug("Personal tokens allowed: '{}', fallback: '{}'", (Object)globalSettings.isAllowPersonal(), (Object)globalSettings.isFallback());
        boolean personalSet = false;
        if (globalSettings.isAllowPersonal()) {
            AzureDevOpsConfiguration configuration = this.personalConfigurationService.get();
            boolean bl = personalSet = configuration.getId() != null && StringUtils.isNotBlank((CharSequence)configuration.getConfiguration().getPersonalAccessToken());
            if (personalSet) {
                configurationsHolder.getConfigurations().add(configuration);
            }
            log.debug("Personal configuration is defined {}", (Object)personalSet);
        }
        if (!personalSet || globalSettings.isFallback()) {
            log.debug("Global configuration is added");
            configurationsHolder.getConfigurations().add((AzureDevOpsConfiguration)this.globalConfigurationService.get());
        } else {
            log.debug("Global configuration is not added");
        }
        return configurationsHolder;
    }
}

