/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.rest;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.QueryLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.PaginationMacroResponse;
import com.moveworkforward.confluence.azure.model.QueryMacroRequest;
import com.moveworkforward.confluence.azure.model.QueryRequest;
import com.moveworkforward.confluence.azure.model.QueryResponse;
import com.moveworkforward.confluence.azure.model.SearchMacroRequest;
import com.moveworkforward.confluence.azure.model.SearchRequest;
import com.moveworkforward.confluence.azure.model.SearchResponse;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.rest.WorkItemFieldsController;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/macro")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class AsyncMacroController {
    private static final Logger log = LoggerFactory.getLogger(AsyncMacroController.class);
    public final AzureRestClient azureRestClient;
    protected final TemplateRenderer renderer;
    private final DelegateAzureDevOpsConfigurationService configurationService;

    @Autowired
    public AsyncMacroController(DelegateAzureDevOpsConfigurationService configurationService, CacheableAzureRestClient azureRestClient, @ComponentImport TemplateRenderer renderer) {
        this.configurationService = configurationService;
        this.azureRestClient = azureRestClient;
        this.renderer = renderer;
    }

    @POST
    @Path(value="/query")
    public PaginationMacroResponse query(QueryMacroRequest queryMacroRequest) {
        String url = queryMacroRequest.getUrl();
        QueryLinkHelper linkHelper = new QueryLinkHelper();
        String azureBaseUrl = linkHelper.getBaseUrl(url);
        List<String> fieldsToDisplay = queryMacroRequest.getFieldsToDisplay();
        fieldsToDisplay.removeIf(StringUtils::isBlank);
        String organizationID = linkHelper.getOrganizationID(url);
        String projectName = linkHelper.getProjectName(url);
        String queryId = linkHelper.getId(url);
        QueryRequest request = new QueryRequest(organizationID, projectName, queryId, queryMacroRequest.getLimit(), queryMacroRequest.getPage(), queryMacroRequest.getRecordsPerPage());
        QueryResponse response = null;
        AzureDevOpsConfiguration configuration = null;
        for (AzureDevOpsConfiguration currentConfiguration : this.configurationService.get().getConfigurations()) {
            log.debug("Get query items using {} configuration", (Object)currentConfiguration.getLevel());
            try {
                response = this.azureRestClient.getQuery(azureBaseUrl, currentConfiguration.getConfiguration().getPersonalAccessToken(), request);
                if (response == null) continue;
                configuration = currentConfiguration;
                break;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, response);
        if (response == null || configuration == null) {
            log.debug("if we don't get a response it means request was failed but PAT is set");
            throw new RuntimeException("Invalid token: " + url);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("name", response.getName());
        model.put("url", url);
        List<WorkItemResponse> workItemResponses = response.getWorkItems();
        String token = configuration.getConfiguration().getPersonalAccessToken();
        Map<String, FieldsResponse.Field> allFields = AzureMacroUtils.getAllFields(this.azureRestClient, azureBaseUrl, token, organizationID, projectName, WorkItemFieldsController.DEFAULT_PARAMETERS);
        List workItems = workItemResponses.stream().map(AzureMacroUtils::workItemToModel).collect(Collectors.toList());
        model.put("workItems", workItems);
        model.put("fieldsToDisplay", fieldsToDisplay);
        model.put("allFields", allFields);
        return new PaginationMacroResponse(queryMacroRequest.getPage(), response.getTotal(), AzureMacroUtils.render(this.renderer, model, "templates/mwf-ado-work-items-content.vm"));
    }

    @POST
    @Path(value="/search")
    public PaginationMacroResponse search(SearchMacroRequest searchMacroRequest) {
        for (AzureDevOpsConfiguration configuration : this.configurationService.get().getConfigurations()) {
            log.debug("Search work items using {} configuration", (Object)configuration.getLevel());
            String url = AzureMacroUtils.getSearchUrl(searchMacroRequest.getUrl(), configuration);
            Integer limit = searchMacroRequest.getLimit();
            String organizationID = AzureMacroUtils.getSearchOrganization(searchMacroRequest.getOrganization(), configuration);
            String projectName = searchMacroRequest.getProject();
            String searchText = searchMacroRequest.getSearchText();
            List<String> fieldsToDisplay = searchMacroRequest.getFieldsToDisplay();
            fieldsToDisplay.removeIf(StringUtils::isBlank);
            String projectCondition = StringUtils.isBlank((CharSequence)projectName) ? "" : String.format("and [System.TeamProject] = '%1$s'", projectName);
            String query = String.format("select [System.Id] from WorkItems where ([System.Title] contains words '%1$s' or [System.Description] contains words '%1$s') %2$s order by [System.ChangedDate] desc", searchText, projectCondition);
            SearchRequest request = new SearchRequest(organizationID, projectName, query, limit, searchMacroRequest.getPage(), searchMacroRequest.getRecordsPerPage());
            try {
                SearchResponse response = this.azureRestClient.searchItems(url, configuration.getConfiguration().getPersonalAccessToken(), request);
                log.debug("URL: {}, response: {}", (Object)url, (Object)response);
                if (response == null) continue;
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("url", url);
                List<WorkItemResponse> workItemResponses = response.getWorkItems();
                String token = configuration.getConfiguration().getPersonalAccessToken();
                Map<String, FieldsResponse.Field> allFields = AzureMacroUtils.getAllFields(this.azureRestClient, url, token, organizationID, projectName, WorkItemFieldsController.DEFAULT_PARAMETERS);
                List workItems = workItemResponses.stream().map(AzureMacroUtils::workItemToModel).collect(Collectors.toList());
                model.put("workItems", workItems);
                model.put("fieldsToDisplay", fieldsToDisplay);
                model.put("allFields", allFields);
                model.put("organization", organizationID);
                model.put("project", projectName);
                model.put("searchText", searchText);
                String html = null;
                html = response.getTotal() > 0 ? AzureMacroUtils.render(this.renderer, model, "templates/mwf-ado-work-items-content.vm") : AzureMacroUtils.render(this.renderer, model, "templates/mwf-ado-empty-search.vm");
                return new PaginationMacroResponse(searchMacroRequest.getPage(), response.getTotal(), html);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("if we don't get a response it means request was failed but PAT is set");
        throw new RuntimeException("Invalid token: " + searchMacroRequest.getUrl());
    }
}

