/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.PipelineLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.BuildStatusResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PipelineBuildStatusProcessor
extends AbstractAzureLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(PipelineBuildStatusProcessor.class);

    @Autowired
    public PipelineBuildStatusProcessor(@Qualifier(value="AzureRestClient") AzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new PipelineLinkHelper());
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        String azureBaseUrl = ((AzureLinkHelper)this.linkHelper).getBaseUrl(url);
        String organizationID = ((AzureLinkHelper)this.linkHelper).getOrganizationID(url);
        String projectName = ((AzureLinkHelper)this.linkHelper).getProjectName(url);
        String definitionId = ((AzureLinkHelper)this.linkHelper).getId(url);
        GeneralRequest request = new GeneralRequest(organizationID, projectName, definitionId);
        BuildStatusResponse response = null;
        for (AzureDevOpsConfiguration configuration : configurationsHolder.getConfigurations()) {
            log.debug("Get build status using {} configuration", (Object)configuration.getLevel());
            try {
                response = this.azureRestClient.getBuildStatus(azureBaseUrl, configuration.getConfiguration().getPersonalAccessToken(), request);
                if (response == null) continue;
                break;
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, response);
        if (response == null || CollectionUtils.isEmpty(response.getValue())) {
            return this.renderNoToken(url);
        }
        Map<String, Object> model = this.buildStatusToModel(response);
        return this.render(model, "templates/mwf-ado-build-status.vm");
    }

    private Map<String, Object> buildStatusToModel(BuildStatusResponse response) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        BuildStatusResponse.BuildStatus buildStatus = response.getValue().get(0);
        model.put("buildNumber", buildStatus.getBuildNumber());
        model.put("pipeline", buildStatus.getDefinition().getName());
        model.put("pipelineUrl", buildStatus.getDefinition().getLinks().getWeb().getHref());
        model.put("project", buildStatus.getProject().getName());
        model.put("projectUrl", buildStatus.getProject().getLinks().getWeb().getHref());
        model.put("status", buildStatus.getStatus());
        model.put("result", buildStatus.getResult());
        model.put("buildUrl", buildStatus.getLinks().getWeb().getHref());
        model.put("statusBadge", buildStatus.getLinks().getBadge().getHref() + "?label=status");
        try {
            model.put("duration", this.formatDuration(buildStatus.getStartTime(), buildStatus.getFinishTime()));
        }
        catch (Exception e) {
            model.put("duration", "unknown");
        }
        return model;
    }

    private String formatDuration(String startTime, String finishTime) {
        LocalDateTime ldt2;
        LocalDateTime ldt1 = LocalDateTime.parse(startTime.replace("Z", ""));
        Duration duration = Duration.between(ldt1, ldt2 = LocalDateTime.parse(finishTime.replace("Z", "")));
        String pattern = duration.toHours() > 0L ? "HH'h' mm'm' ss's'" : "mm'm' ss's'";
        pattern = duration.toMinutes() > 0L ? pattern : "ss's'";
        return DurationFormatUtils.formatDuration((long)duration.toMillis(), (String)pattern, (boolean)false);
    }
}

