/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.azure.ao.AzureGlobalSettingsRepository;
import com.moveworkforward.confluence.azure.model.AzureGlobalSettings;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AzureGlobalSettingsService {
    private final AzureGlobalSettingsRepository repository;
    protected final PermissionManager permissionManager;

    @Autowired
    public AzureGlobalSettingsService(AzureGlobalSettingsRepository repository, @ComponentImport PermissionManager permissionManager) {
        this.repository = repository;
        this.permissionManager = permissionManager;
    }

    public AzureGlobalSettings get(boolean checkPermissions) {
        if (checkPermissions) {
            this.checkAdminPermissions();
        }
        AzureGlobalSettings globalSettings = this.repository.getAll().stream().findFirst().orElse(new AzureGlobalSettings());
        return globalSettings;
    }

    public AzureGlobalSettings save(AzureGlobalSettings globalSettings) {
        this.checkAdminPermissions();
        AzureGlobalSettings saved = this.get(AbstractConfigurationService.DO_NOT_CHECK_PERMISSIONS);
        if (saved.getId() != null) {
            globalSettings.setId(saved.getId());
        }
        return (AzureGlobalSettings)this.repository.save((PluginEntity)globalSettings);
    }

    protected void checkAdminPermissions() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator((User)confluenceUser)) {
            throw new RuntimeException("User doesn't have permissions");
        }
    }
}

