/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.rest;

import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.service.AzureDevOpsGlobalConfigurationService;
import com.moveworkforward.confluence.azure.service.AzureDevOpsPersonalConfigurationService;
import com.moveworkforward.confluence.common.AbstractLinkController;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Path(value="/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class AzureLinkController
extends AbstractLinkController<AzureDevOpsConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(AzureLinkController.class);
    private final AzureDevOpsPersonalConfigurationService personalConfigurationService;

    @Autowired
    public AzureLinkController(AzureDevOpsGlobalConfigurationService globalConfigurationService, AzureDevOpsPersonalConfigurationService personalConfigurationService) {
        super((AbstractConfigurationService)globalConfigurationService);
        this.personalConfigurationService = personalConfigurationService;
    }

    protected AzureDevOpsConfiguration hideToken(AzureDevOpsConfiguration configuration) {
        if (configuration != null && configuration.getConfiguration() != null && !StringUtils.isEmpty((Object)configuration.getConfiguration().getPersonalAccessToken())) {
            configuration.getConfiguration().setPersonalAccessToken("XXXXXXXXX");
        }
        return configuration;
    }

    @GET
    @Path(value="/personal")
    public AzureDevOpsConfiguration getPersonal(@QueryParam(value="userKey") String userKey) {
        return this.hideToken(this.personalConfigurationService.get(userKey, AbstractConfigurationService.CHECK_PERMISSIONS));
    }

    @POST
    @Path(value="/personal")
    public AzureDevOpsConfiguration savePersonal(AzureDevOpsConfiguration configuration) {
        return this.hideToken(this.personalConfigurationService.save(configuration));
    }

    @DELETE
    @Path(value="/personal")
    public AzureDevOpsConfiguration deletePersonal(@QueryParam(value="userKey") String userKey) {
        return this.hideToken(this.personalConfigurationService.delete(userKey));
    }
}

