/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.DelegateReleaseLinkHelper;
import com.moveworkforward.confluence.azure.link.ReleasesLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.ReleaseRequest;
import com.moveworkforward.confluence.azure.model.ReleaseResponse;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import com.moveworkforward.confluence.common.processor.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleasesLinkProcessor
extends AbstractAzureLinkProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(ReleasesLinkProcessor.class);

    @Autowired
    public ReleasesLinkProcessor(CacheableAzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new DelegateReleaseLinkHelper());
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        String azureBaseUrl = ((AzureLinkHelper)this.linkHelper).getBaseUrl(url);
        String organizationID = ((AzureLinkHelper)this.linkHelper).getOrganizationID(url);
        String projectName = ((AzureLinkHelper)this.linkHelper).getProjectName(url);
        String id = ((AzureLinkHelper)this.linkHelper).getId(url);
        Integer limit = AzureMacroUtils.getIntegerValue(parameters, "itemsCount", null);
        ReleaseRequest request = new ReleaseRequest(organizationID, projectName, id, limit);
        List<Object> releases = new ArrayList();
        for (AzureDevOpsConfiguration configuration : configurationsHolder.getConfigurations()) {
            log.debug("Get releases using {} configuration", (Object)configuration.getLevel());
            try {
                ReleaseResponse release = null;
                if (((DelegateReleaseLinkHelper)this.linkHelper).getAccepted(url) instanceof ReleasesLinkHelper) {
                    releases = this.azureRestClient.getReleases(azureBaseUrl, configuration.getConfiguration().getPersonalAccessToken(), request).getValue();
                    if (!CollectionUtils.isNotEmpty(releases)) continue;
                    break;
                }
                release = this.azureRestClient.getRelease(azureBaseUrl, configuration.getConfiguration().getPersonalAccessToken(), request);
                if (release == null) continue;
                releases.add(release);
                break;
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, releases);
        if (CollectionUtils.isEmpty(releases)) {
            return this.renderNoToken(url);
        }
        releases.forEach(r -> {
            if (CollectionUtils.isEmpty(r.getEnvironments())) {
                return;
            }
            r.getEnvironments().forEach(environment -> {
                String status = environment.getStatus();
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    status = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)status)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
                    environment.setStatus(status);
                }
            });
        });
        HashMap model = new HashMap();
        model.put("releases", releases);
        return this.render(model, "templates/mwf-ado-releases.vm");
    }
}

