/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.rest;

import com.google.common.collect.ImmutableMap;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.DelegateWorkItemLinkHelper;
import com.moveworkforward.confluence.azure.link.QueryLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.processor.SearchWorkItemsProcessor;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/work-items")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class WorkItemFieldsController {
    private static final Logger log = LoggerFactory.getLogger(WorkItemFieldsController.class);
    public static final String WORK_ITEM_ID = "System.Id";
    public static final Map<String, AzureLinkHelper> LINK_HELPERS = ImmutableMap.builder().put((Object)"azure-devops-query-link", (Object)new QueryLinkHelper()).put((Object)"azure-devops-work-item-link", (Object)new DelegateWorkItemLinkHelper()).put((Object)"azure-devops-link", (Object)new DelegateWorkItemLinkHelper()).put((Object)"azure-devops-search-work-items", (Object)new AbstractLinkHelper(){

        @Override
        public String getKeyPath() {
            return "";
        }
    }).build();
    public static final Map<String, String> DEFAULT_PARAMETERS = ImmutableMap.builder().put((Object)"System.WorkItemType", (Object)"Work Item Type").put((Object)"System.Title", (Object)"Title").put((Object)"System.State", (Object)"State").put((Object)"System.AssignedTo", (Object)"Assigned To").build();
    private final AzureRestClient azureRestClient;
    private final MacroConfigurationService<AzureConfigurationsHolder> configurationService;
    private final SearchWorkItemsProcessor searchWorkItemsProcessor;

    @Autowired
    public WorkItemFieldsController(CacheableAzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, SearchWorkItemsProcessor searchWorkItemsProcessor) {
        this.azureRestClient = azureRestClient;
        this.configurationService = configurationService;
        this.searchWorkItemsProcessor = searchWorkItemsProcessor;
    }

    @POST
    @Path(value="/fields")
    public Map<String, String> getFields(FieldsRequest fieldsRequest) {
        try {
            if (StringUtils.isBlank((CharSequence)fieldsRequest.getKey()) || !LINK_HELPERS.containsKey(fieldsRequest.getKey())) {
                return DEFAULT_PARAMETERS;
            }
            AzureConfigurationsHolder configurationsHolder = (AzureConfigurationsHolder)this.configurationService.get();
            if (configurationsHolder.isEmpty()) {
                return DEFAULT_PARAMETERS;
            }
            for (AzureDevOpsConfiguration configuration : configurationsHolder.getConfigurations()) {
                log.debug("Get fields using {} configuration", (Object)configuration.getLevel());
                try {
                    return this.doGetFields(fieldsRequest, configuration);
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return DEFAULT_PARAMETERS;
    }

    private Map<String, String> doGetFields(FieldsRequest fieldsRequest, AzureDevOpsConfiguration configuration) {
        String url;
        AzureLinkHelper linkHelper;
        if ("azure-devops-search-work-items".equals(fieldsRequest.getKey())) {
            Map<String, String> parameters = fieldsRequest.getParameters();
            String baseUrl = this.searchWorkItemsProcessor.getUrl(parameters, configuration);
            if (baseUrl != null && baseUrl.startsWith("http") && StringUtils.isNotBlank((CharSequence)this.searchWorkItemsProcessor.getOrganization(parameters, configuration))) {
                String projectName = parameters.get("project");
                GeneralRequest request = new GeneralRequest(this.searchWorkItemsProcessor.getOrganization(parameters, configuration), projectName, null);
                FieldsResponse response = this.azureRestClient.getFields(baseUrl, configuration.getConfiguration().getPersonalAccessToken(), request);
                return response.getValue().stream().filter(field -> !WORK_ITEM_ID.equals(field.getReferenceName())).collect(Collectors.toMap(FieldsResponse.Field::getReferenceName, FieldsResponse.Field::getName));
            }
        } else if (StringUtils.isNotBlank((CharSequence)fieldsRequest.getParameters().get("url")) && (linkHelper = LINK_HELPERS.get(fieldsRequest.getKey())).isAccepted(url = fieldsRequest.getParameters().get("url"))) {
            String baseUrl = linkHelper.getBaseUrl(url);
            String organizationID = linkHelper.getOrganizationID(url);
            String projectName = linkHelper.getProjectName(url);
            GeneralRequest request = new GeneralRequest(organizationID, projectName, null);
            FieldsResponse response = this.azureRestClient.getFields(baseUrl, configuration.getConfiguration().getPersonalAccessToken(), request);
            return response.getValue().stream().filter(field -> !WORK_ITEM_ID.equals(field.getReferenceName())).collect(Collectors.toMap(FieldsResponse.Field::getReferenceName, FieldsResponse.Field::getName));
        }
        return DEFAULT_PARAMETERS;
    }

    @JsonAutoDetect
    @JsonIgnoreProperties
    public static class FieldsRequest {
        private String key;
        private Map<String, String> parameters = new LinkedHashMap<String, String>();

        public String getKey() {
            return this.key;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }
    }
}

