/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.CacheableAzureRestClient;
import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import com.moveworkforward.confluence.azure.utils.AzureMacroUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchWorkItemsProcessor
extends AbstractAzureLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(SearchWorkItemsProcessor.class);

    @Autowired
    protected SearchWorkItemsProcessor(CacheableAzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new AbstractLinkHelper(){

            @Override
            public String getKeyPath() {
                return "";
            }
        });
    }

    public boolean canProcess(Map<String, String> parameters) {
        AzureConfigurationsHolder configurationsHolder = (AzureConfigurationsHolder)this.configurationService.get();
        Iterator<AzureDevOpsConfiguration> iterator = configurationsHolder.getConfigurations().iterator();
        if (iterator.hasNext()) {
            AzureDevOpsConfiguration configuration = iterator.next();
            String url = this.getUrl(parameters, configuration);
            return url != null && url.startsWith("http") && StringUtils.isNotBlank((CharSequence)this.getOrganization(parameters, configuration)) && StringUtils.isNotBlank((CharSequence)parameters.get("searchText"));
        }
        return false;
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        for (AzureDevOpsConfiguration configuration : configurationsHolder.getConfigurations()) {
            log.debug("Search work items using {} configuration", (Object)configuration.getLevel());
            try {
                String url = this.getUrl(parameters, configuration);
                boolean hideHeader = Boolean.parseBoolean(parameters.get("hideHeader"));
                int limit = AzureMacroUtils.getIntegerValue(parameters, "itemsCount", -1);
                int recordsPerPage = AzureMacroUtils.getIntegerValue(parameters, "recordsPerPage", 10);
                String organizationID = this.getOrganization(parameters, configuration);
                String projectName = parameters.get("project");
                String searchText = parameters.get("searchText");
                HashMap<String, Object> model = new HashMap<String, Object>();
                Set<String> fieldsToDisplay = AzureMacroUtils.getFieldsToDisplay(parameters);
                String token = configuration.getConfiguration().getPersonalAccessToken();
                Map<String, String> allFields = AzureMacroUtils.getAllFields(this.azureRestClient, url, token, organizationID, projectName, null);
                if (allFields == null) continue;
                model.put("url", url);
                model.put("searchText", searchText);
                model.put("limit", limit);
                model.put("organization", organizationID);
                model.put("project", projectName);
                model.put("fieldsToDisplay", fieldsToDisplay);
                model.put("allFields", allFields);
                model.put("hideHeader", hideHeader);
                model.put("recordsPerPage", recordsPerPage);
                model.put("baseUrl", this.getBaseUrl());
                model.put("macro", "search");
                model.put("macroName", this.i18nResolver.getText("azure-devops-confluence-integration.azure-devops-search-work-items.label"));
                model.put("uuid", UUID.randomUUID().toString());
                model.put("paginationUrl", this.getBaseUrl() + "/rest/azure-devops/1.0/macro/search");
                return this.render(model, "templates/mwf-ado-paginated-work-items.vm");
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.renderNoToken(parameters.getOrDefault("url", "Unknown"));
    }

    public String getUrl(Map<String, String> parameters, AzureDevOpsConfiguration configuration) {
        return configuration.getConfiguration().isUseBaseUrl() ? configuration.getConfiguration().getBaseUrl() : parameters.get("url");
    }

    public String getOrganization(Map<String, String> parameters, AzureDevOpsConfiguration configuration) {
        return configuration.getConfiguration().isUseOrganization() ? configuration.getConfiguration().getOrganization() : parameters.get("organization");
    }
}

