/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.actions;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.user.User;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.service.AzureDevOpsPersonalConfigurationService;
import com.moveworkforward.confluence.common.LicenseManager;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;

public class PersonalViewConfigurationAction
extends AbstractUserProfileAction {
    private final PermissionManager permissionManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final LicenseManager licenseManager;
    private final AzureDevOpsPersonalConfigurationService configurationService;

    public PersonalViewConfigurationAction(@ComponentImport PermissionManager permissionManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, LicenseManager licenseManager, AzureDevOpsPersonalConfigurationService configurationService) {
        this.permissionManager = permissionManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.licenseManager = licenseManager;
        this.configurationService = configurationService;
    }

    public AzureDevOpsConfiguration getConfiguration() {
        return this.configurationService.get(this.getUser().getKey().getStringValue(), AbstractConfigurationService.CHECK_PERMISSIONS);
    }

    public boolean isPermitted() {
        return this.permissionManager.isConfluenceAdministrator((User)this.getAuthenticatedUser());
    }

    public boolean isLicenseValid() {
        return this.licenseManager.isLicensed();
    }

    public String getHostBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public String execute() {
        return "success";
    }
}

