/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.QueryLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.QueryResponse;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryLinkProcessor
extends AbstractAzureLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryLinkProcessor.class);

    @Autowired
    public QueryLinkProcessor(AzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new QueryLinkHelper());
    }

    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        boolean showOnlyCount = Boolean.parseBoolean(parameters.get("showOnlyCount"));
        boolean hideHeader = Boolean.parseBoolean(parameters.get("hideHeader"));
        int itemsCount = this.getItemsCount(parameters);
        String azureBaseUrl = ((AzureLinkHelper)this.linkHelper).getBaseUrl(url);
        String organizationID = ((AzureLinkHelper)this.linkHelper).getOrganizationID(url);
        String projectName = ((AzureLinkHelper)this.linkHelper).getProjectName(url);
        String queryId = ((AzureLinkHelper)this.linkHelper).getId(url);
        GeneralRequest request = new GeneralRequest(organizationID, projectName, queryId);
        QueryResponse response = null;
        AzureDevOpsConfiguration configuration = null;
        for (AzureDevOpsConfiguration currentConfiguration : configurationsHolder.getConfigurations()) {
            log.debug("Get query items using {} configuration", (Object)currentConfiguration.getLevel());
            try {
                response = this.azureRestClient.getQuery(azureBaseUrl, currentConfiguration.getConfiguration().getPersonalAccessToken(), request);
                if (response == null) continue;
                configuration = currentConfiguration;
                break;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, response);
        if (response == null || configuration == null) {
            log.debug("if we don't get a response it means request was failed but PAT is set");
            return this.renderNoToken(url);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("showOnlyCount", showOnlyCount);
        model.put("name", response.getName());
        model.put("url", url);
        List<WorkItemResponse> workItemResponses = response.getWorkItems();
        if (showOnlyCount) {
            model.put("itemsCount", workItemResponses.size());
            model.put("workItems", Collections.emptyList());
            model.put("fieldsToDisplay", Collections.emptyList());
            model.put("hideHeader", hideHeader);
            model.put("allFields", Collections.emptyList());
        } else {
            if (itemsCount > 0) {
                workItemResponses = workItemResponses.subList(0, Math.min(workItemResponses.size(), itemsCount));
            }
            Set<String> fieldsToDisplay = this.getFieldsToDisplay(parameters);
            Map<String, String> allFields = this.getAllFields(azureBaseUrl, configuration.getConfiguration().getPersonalAccessToken(), organizationID, projectName);
            List workItems = workItemResponses.stream().map(this::workItemToModel).collect(Collectors.toList());
            model.put("workItems", workItems);
            model.put("fieldsToDisplay", fieldsToDisplay);
            model.put("hideHeader", hideHeader);
            model.put("allFields", allFields);
        }
        return this.render(model, "templates/mwf-ado-work-items.vm");
    }

    private int getItemsCount(Map<String, String> parameters) {
        int itemsCount = -1;
        try {
            String itemsCountParam = parameters.get("itemsCount");
            if (StringUtils.isNotBlank((CharSequence)itemsCountParam)) {
                itemsCount = Integer.parseInt(itemsCountParam);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemsCount;
    }
}

